/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.StreamPumper;

public class PumpStreamHandler
implements ExecuteStreamHandler {
    private Thread inputThread;
    private Thread errorThread;
    private OutputStream out;
    private OutputStream err;

    public PumpStreamHandler(OutputStream outputStream, OutputStream outputStream2) {
        this.out = outputStream;
        this.err = outputStream2;
    }

    public PumpStreamHandler(OutputStream outputStream) {
        this(outputStream, outputStream);
    }

    public PumpStreamHandler() {
        this(System.out, System.err);
    }

    public void setProcessOutputStream(InputStream inputStream) {
        this.createProcessOutputPump(inputStream, this.out);
    }

    public void setProcessErrorStream(InputStream inputStream) {
        this.createProcessErrorPump(inputStream, this.err);
    }

    public void setProcessInputStream(OutputStream outputStream) {
    }

    public void start() {
        this.inputThread.start();
        this.errorThread.start();
    }

    public void stop() {
        try {
            this.inputThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.errorThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.err.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected OutputStream getErr() {
        return this.err;
    }

    protected OutputStream getOut() {
        return this.out;
    }

    protected void createProcessOutputPump(InputStream inputStream, OutputStream outputStream) {
        this.inputThread = this.createPump(inputStream, outputStream);
    }

    protected void createProcessErrorPump(InputStream inputStream, OutputStream outputStream) {
        this.errorThread = this.createPump(inputStream, outputStream);
    }

    protected Thread createPump(InputStream inputStream, OutputStream outputStream) {
        Thread thread = new Thread(new StreamPumper(inputStream, outputStream));
        thread.setDaemon(true);
        return thread;
    }
}

