/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import org.exolab.castor.builder.CollectionInfo;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.types.XSListJ2;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class CollectionInfoJ2
extends CollectionInfo {
    public CollectionInfoJ2(XSType xSType, String string, String string2) {
        super(xSType, string, string2);
        this.setSchemaType(new XSListJ2(xSType));
    }

    public void generateInitializerCode(JSourceCode jSourceCode) {
        jSourceCode.add(this.getName());
        jSourceCode.append(" = new ArrayList();");
    }

    public void createAccessMethods(JClass jClass) {
        Object object;
        JMethod jMethod = null;
        JType jType = this.getContentType().getJType();
        JParameter jParameter = new JParameter(jType, this.getContentName());
        Object var5_5 = null;
        String string = JavaNaming.toJavaClassName(this.getElementName());
        jMethod = new JMethod(null, "add" + string);
        jClass.addMethod(jMethod);
        jMethod.addException(SGTypes.IndexOutOfBoundsException);
        jMethod.addParameter(jParameter);
        this.createAddMethod(jMethod);
        jMethod = new JMethod(null, "add" + string);
        jClass.addMethod(jMethod);
        jMethod.addException(SGTypes.IndexOutOfBoundsException);
        jMethod.addParameter(new JParameter(JType.Int, "index"));
        jMethod.addParameter(jParameter);
        this.createAddInsertMethod(jMethod);
        jMethod = new JMethod(jType, "get" + string);
        jClass.addMethod(jMethod);
        jMethod.addException(SGTypes.IndexOutOfBoundsException);
        jMethod.addParameter(new JParameter(JType.Int, "index"));
        this.createGetByIndexMethod(jMethod);
        jMethod = new JMethod(jType.createArray(), "get" + string);
        jClass.addMethod(jMethod);
        this.createGetMethod(jMethod);
        if (this.extraMethods()) {
            object = SourceGenerator.getProperty("org.exolab.castor.builder.collections.reference.suffix", "AsReference");
            jMethod = new JMethod(SGTypes.ArrayList, "get" + string + (String)object);
            jClass.addMethod(jMethod);
            this.createGetCollectionReferenceMethod(jMethod);
        }
        jMethod = new JMethod(null, "set" + string);
        jClass.addMethod(jMethod);
        jMethod.addException(SGTypes.IndexOutOfBoundsException);
        jMethod.addParameter(new JParameter(JType.Int, "index"));
        jMethod.addParameter(jParameter);
        this.createSetByIndexMethod(jMethod);
        object = jParameter.getType().createArray();
        String string2 = JavaNaming.toJavaMemberName(string);
        JParameter jParameter2 = new JParameter((JType)object, string2 + "Array");
        jMethod = new JMethod(null, "set" + string);
        jMethod.addParameter(jParameter2);
        jClass.addMethod(jMethod);
        this.createSetArrayMethod(jMethod);
        if (this.extraMethods()) {
            JParameter jParameter3 = new JParameter(SGTypes.ArrayList, string2 + "Collection");
            jMethod = new JMethod(null, "set" + string);
            jMethod.addParameter(jParameter3);
            jClass.addMethod(jMethod);
            this.createSetCollectionMethod(jMethod);
            String string3 = SourceGenerator.getProperty("org.exolab.castor.builder.collections.reference.suffix", "AsReference");
            jMethod = new JMethod(null, "set" + string + string3);
            jMethod.addParameter(jParameter3);
            jClass.addMethod(jMethod);
            this.createSetCollectionReferenceMethod(jMethod);
        }
        jMethod = new JMethod(SGTypes.Enumeration, "enumerate" + string);
        jClass.addMethod(jMethod);
        this.createEnumerateMethod(jMethod);
        jMethod = new JMethod(JType.Int, "get" + string + "Count");
        jClass.addMethod(jMethod);
        this.createGetCountMethod(jMethod);
        jMethod = new JMethod(JType.Boolean, "remove" + string);
        jMethod.addParameter(jParameter);
        this.createRemoveMethod(jMethod);
        jClass.addMethod(jMethod);
        jMethod = new JMethod(null, "clear" + string);
        this.createClearMethod(jMethod);
        jClass.addMethod(jMethod);
    }

    public void createAddMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        int n = this.getXSList().getMaximumSize();
        if (n > 0) {
            jSourceCode.add("if (!(");
            jSourceCode.append(this.getName());
            jSourceCode.append(".size() < ");
            jSourceCode.append(Integer.toString(n));
            jSourceCode.append(")) {");
            jSourceCode.indent();
            jSourceCode.add("throw new IndexOutOfBoundsException();");
            jSourceCode.unindent();
            jSourceCode.add("}");
        }
        jSourceCode.add(this.getName());
        jSourceCode.append(".add(");
        jSourceCode.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jSourceCode.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
    }

    public void createAddInsertMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        int n = this.getXSList().getMaximumSize();
        if (n > 0) {
            jSourceCode.add("if (!(");
            jSourceCode.append(this.getName());
            jSourceCode.append(".size() < ");
            jSourceCode.append(Integer.toString(n));
            jSourceCode.append(")) {");
            jSourceCode.indent();
            jSourceCode.add("throw new IndexOutOfBoundsException();");
            jSourceCode.unindent();
            jSourceCode.add("}");
        }
        jSourceCode.add(this.getName());
        jSourceCode.append(".add(index, ");
        jSourceCode.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jSourceCode.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
    }

    public void createEnumerateMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("return new org.exolab.castor.util.IteratorEnumeration(");
        jSourceCode.append(this.getName());
        jSourceCode.append(".iterator());");
    }

    public void createGetMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        JType jType = jMethod.getReturnType();
        jSourceCode.add("int size = ");
        jSourceCode.append(this.getName());
        jSourceCode.append(".size();");
        String string = this.getName() + ".get(index)";
        JType jType2 = jType.getComponentType();
        jSourceCode.add(jType2.toString());
        jSourceCode.append("[] mArray = new ");
        if (jType2.isArray()) {
            jSourceCode.append(jType2.getComponentType().toString());
        } else {
            jSourceCode.append(jType2.toString());
        }
        jSourceCode.append("[size]");
        if (jType2.isArray()) {
            jSourceCode.append("[]");
        }
        jSourceCode.append(";");
        jSourceCode.add("for (int index = 0; index < size; index++) {");
        jSourceCode.indent();
        jSourceCode.add("mArray[index] = ");
        if (this.getContentType().getType() == 0) {
            jSourceCode.append("(");
            jSourceCode.append(jType.getName());
            jSourceCode.append(") ");
            jSourceCode.append(string);
        } else {
            jSourceCode.append(this.getContentType().createFromJavaObjectCode(string));
        }
        jSourceCode.append(";");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("return mArray;");
    }

    public void createGetByIndexMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        JType jType = jMethod.getReturnType();
        jSourceCode.add("//-- check bounds for index");
        jSourceCode.add("if ((index < 0) || (index > ");
        jSourceCode.append(this.getName());
        jSourceCode.append(".size())) {");
        jSourceCode.indent();
        jSourceCode.add("throw new IndexOutOfBoundsException();");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("");
        jSourceCode.add("return ");
        String string = this.getName() + ".get(index)";
        if (this.getContentType().getType() == 0) {
            jSourceCode.append("(");
            jSourceCode.append(jType.toString());
            jSourceCode.append(") ");
            jSourceCode.append(string);
        } else {
            jSourceCode.append(this.getContentType().createFromJavaObjectCode(string));
        }
        jSourceCode.append(";");
    }

    public void createGetCollectionReferenceMethod(JMethod jMethod) {
        String string = JavaNaming.toJavaMemberName(this.getElementName());
        JDocComment jDocComment = jMethod.getJDocComment();
        jDocComment.appendComment("Returns a reference to '");
        jDocComment.appendComment(string);
        jDocComment.appendComment("'.");
        jDocComment.appendComment(" No type checking is performed on any ");
        jDocComment.appendComment("modications to the Collection.");
        JDocDescriptor jDocDescriptor = JDocDescriptor.createReturnDesc();
        jDocDescriptor.setDescription("returns a reference to the Collection.");
        jDocComment.addDescriptor(jDocDescriptor);
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("return ");
        jSourceCode.append(this.getName() + ';');
    }

    public void createSetArrayMethod(JMethod jMethod) {
        String string;
        JSourceCode jSourceCode = jMethod.getSourceCode();
        String string2 = jMethod.getParameter(0).getName();
        if (string2.equals(string = "i")) {
            string = "j";
        }
        jSourceCode.add("//-- copy array");
        jSourceCode.add(this.getName());
        jSourceCode.append(".clear();");
        jSourceCode.add("for (int ");
        jSourceCode.append(string);
        jSourceCode.append(" = 0; ");
        jSourceCode.append(string);
        jSourceCode.append(" < ");
        jSourceCode.append(string2);
        jSourceCode.append(".length; ");
        jSourceCode.append(string);
        jSourceCode.append("++) {");
        jSourceCode.indent();
        jSourceCode.add(this.getName());
        jSourceCode.append(".add(");
        jSourceCode.append(this.getContentType().createToJavaObjectCode(string2 + '[' + string + ']'));
        jSourceCode.append(");");
        jSourceCode.unindent();
        jSourceCode.add("}");
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
    }

    public void createSetByIndexMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("//-- check bounds for index");
        jSourceCode.add("if ((index < 0) || (index > ");
        jSourceCode.append(this.getName());
        jSourceCode.append(".size())) {");
        jSourceCode.indent();
        jSourceCode.add("throw new IndexOutOfBoundsException();");
        jSourceCode.unindent();
        jSourceCode.add("}");
        int n = this.getXSList().getMaximumSize();
        if (n > 0) {
            jSourceCode.add("if (!(");
            jSourceCode.append("index < ");
            jSourceCode.append(Integer.toString(n));
            jSourceCode.append(")) {");
            jSourceCode.indent();
            jSourceCode.add("throw new IndexOutOfBoundsException();");
            jSourceCode.unindent();
            jSourceCode.add("}");
        }
        jSourceCode.add(this.getName());
        jSourceCode.append(".set(index, ");
        jSourceCode.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jSourceCode.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
    }

    public void createSetCollectionMethod(JMethod jMethod) {
        String string = JavaNaming.toJavaMemberName(this.getElementName());
        String string2 = jMethod.getParameter(0).getName();
        JDocComment jDocComment = jMethod.getJDocComment();
        jDocComment.appendComment("Sets the value of '");
        jDocComment.appendComment(string);
        jDocComment.appendComment("' by copying the given ArrayList.");
        JDocDescriptor jDocDescriptor = jDocComment.getParamDescriptor(string2);
        jDocDescriptor.setDescription("the Vector to copy.");
        JSourceCode jSourceCode = jMethod.getSourceCode();
        String string3 = "i";
        if (string2.equals(string3)) {
            string3 = "j";
        }
        jSourceCode.add("//-- copy collection");
        jSourceCode.add(this.getName());
        jSourceCode.append(".clear();");
        jSourceCode.add("for (int ");
        jSourceCode.append(string3);
        jSourceCode.append(" = 0; ");
        jSourceCode.append(string3);
        jSourceCode.append(" < ");
        jSourceCode.append(string2);
        jSourceCode.append(".size(); ");
        jSourceCode.append(string3);
        jSourceCode.append("++) {");
        jSourceCode.indent();
        jSourceCode.add(this.getName());
        jSourceCode.append(".add(");
        jSourceCode.append('(' + this.getContentType().getJType().toString() + ')');
        jSourceCode.append(this.getContentType().createToJavaObjectCode(string2 + ".get(" + string3 + ')'));
        jSourceCode.append(");");
        jSourceCode.unindent();
        jSourceCode.add("}");
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
    }

    public void createSetCollectionReferenceMethod(JMethod jMethod) {
        String string = JavaNaming.toJavaMemberName(this.getElementName());
        String string2 = jMethod.getParameter(0).getName();
        JDocComment jDocComment = jMethod.getJDocComment();
        jDocComment.appendComment("Sets the value of '");
        jDocComment.appendComment(string);
        jDocComment.appendComment("' by setting it to the given ArrayList.");
        jDocComment.appendComment(" No type checking is performed.");
        JDocDescriptor jDocDescriptor = jDocComment.getParamDescriptor(string2);
        jDocDescriptor.setDescription("the ArrayList to copy.");
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add(this.getName());
        jSourceCode.append(" = ");
        jSourceCode.append(string2 + ';');
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
    }

    public void createRemoveMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("boolean removed = ");
        jSourceCode.append(this.getName());
        jSourceCode.append(".remove(");
        jSourceCode.append(this.getContentType().createToJavaObjectCode(this.getContentName()));
        jSourceCode.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
        jSourceCode.add("return removed;");
    }

    public void createRemoveByObjectMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add("boolean removed = ");
        jSourceCode.append(this.getName());
        jSourceCode.append(".remove(");
        jSourceCode.append(this.getContentName());
        jSourceCode.append(");");
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
        jSourceCode.add("return removed;");
    }

    public void createRemoveByIndexMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        JType jType = jMethod.getReturnType();
        jSourceCode.add("java.lang.Object obj = ");
        jSourceCode.append(this.getName());
        jSourceCode.append(".get(index);");
        jSourceCode.add(this.getName());
        jSourceCode.append(".remove(index);");
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
        jSourceCode.add("return ");
        if (this.getContentType().getType() == 0) {
            jSourceCode.append("(");
            jSourceCode.append(jType.getName());
            jSourceCode.append(") obj;");
        } else {
            jSourceCode.append(this.getContentType().createFromJavaObjectCode("obj"));
            jSourceCode.append(";");
        }
    }

    public void createRemoveAllMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add(this.getName());
        jSourceCode.append(".clear();");
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
    }

    public void createClearMethod(JMethod jMethod) {
        JSourceCode jSourceCode = jMethod.getSourceCode();
        jSourceCode.add(this.getName());
        jSourceCode.append(".clear();");
        if (this.isBound()) {
            this.createBoundPropertyCode(jSourceCode);
        }
    }
}

