/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import org.exolab.castor.builder.ClassInfo;
import org.exolab.castor.builder.CollectionInfo;
import org.exolab.castor.builder.FieldInfo;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.XMLInfo;
import org.exolab.castor.builder.types.XSClass;
import org.exolab.castor.builder.types.XSList;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.builder.util.DescriptorJClass;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class DescriptorSourceFactory {
    private static JClass _ClassDescriptorClass = new JClass("org.exolab.castor.mapping.ClassDescriptor");
    private static JClass _FieldDescriptorClass = new JClass("org.exolab.castor.mapping.FieldDescriptor");
    private static JClass fdImplClass = new JClass("org.exolab.castor.xml.util.XMLFieldDescriptorImpl");
    private static JClass fdClass = new JClass("org.exolab.castor.xml.XMLFieldDescriptor");
    private static JType fdArrayClass = fdClass.createArray();
    private static JClass gvrClass = new JClass("org.exolab.castor.xml.GroupValidationRule");
    private static JClass vrClass = new JClass("org.exolab.castor.xml.ValidationRule");
    private static final String DESCRIPTOR_NAME = "Descriptor";
    private static final String FIELD_VALIDATOR_NAME = "fieldValidator";

    public static JClass createSource(ClassInfo classInfo) {
        Object object;
        String string;
        String string2;
        Object var1_1 = null;
        JSourceCode jSourceCode = null;
        Object var3_3 = null;
        JClass jClass = classInfo.getJClass();
        String string3 = jClass.getName();
        String string4 = jClass.getLocalName();
        String string5 = "_" + string3;
        DescriptorJClass descriptorJClass = new DescriptorJClass(string3 + DESCRIPTOR_NAME, jClass);
        JConstructor jConstructor = descriptorJClass.getConstructor(0);
        jSourceCode = jConstructor.getSourceCode();
        String string6 = classInfo.getNamespacePrefix();
        if (string6 != null && string6.length() > 0) {
            jSourceCode.add("nsPrefix = \"");
            jSourceCode.append(string6);
            jSourceCode.append("\";");
        }
        if ((string2 = classInfo.getNamespaceURI()) != null && string2.length() > 0) {
            jSourceCode.add("nsURI = \"");
            jSourceCode.append(string2);
            jSourceCode.append("\";");
        }
        if ((string = classInfo.getNodeName()) != null) {
            jSourceCode.add("xmlName = \"");
            jSourceCode.append(string);
            jSourceCode.append("\";");
        }
        if (classInfo.isChoice()) {
            jSourceCode.add("");
            jSourceCode.add("//-- set grouping compositor");
            jSourceCode.add("setCompositorAsChoice();");
        } else if (classInfo.isSequence()) {
            jSourceCode.add("");
            jSourceCode.add("//-- set grouping compositor");
            jSourceCode.add("setCompositorAsSequence();");
        }
        if (classInfo.getFieldCount() == 0) {
            return descriptorJClass;
        }
        jSourceCode.add("XMLFieldDescriptorImpl  desc           = null;");
        jSourceCode.add("XMLFieldHandler         handler        = null;");
        jSourceCode.add("FieldValidator          fieldValidator = null;");
        if (classInfo.allowContent()) {
            DescriptorSourceFactory.createDescriptor(descriptorJClass, classInfo.getTextField(), string4, null, jSourceCode);
        }
        ClassInfo classInfo2 = classInfo.getBaseClass();
        FieldInfo[] fieldInfoArray = classInfo.getAttributeFields();
        jSourceCode.add("//-- initialize attribute descriptors");
        jSourceCode.add("");
        int n = 0;
        while (n < fieldInfoArray.length) {
            object = fieldInfoArray[n];
            if (!((FieldInfo)object).isTransient()) {
                if (classInfo2 != null && classInfo2.getAttributeField(((XMLInfo)object).getNodeName()) != null) {
                    DescriptorSourceFactory.createRestrictedDescriptor((FieldInfo)object, jSourceCode);
                } else {
                    DescriptorSourceFactory.createDescriptor(descriptorJClass, (FieldInfo)object, string4, string2, jSourceCode);
                }
            }
            ++n;
        }
        object = classInfo.getElementFields();
        jSourceCode.add("//-- initialize element descriptors");
        jSourceCode.add("");
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            Object object2 = object[n2];
            if (!((FieldInfo)object2).isTransient()) {
                if (classInfo2 != null && classInfo2.getElementField(((XMLInfo)object2).getNodeName()) != null) {
                    DescriptorSourceFactory.createRestrictedDescriptor((FieldInfo)object2, jSourceCode);
                } else {
                    DescriptorSourceFactory.createDescriptor(descriptorJClass, (FieldInfo)object2, string4, string2, jSourceCode);
                }
            }
            ++n2;
        }
        return descriptorJClass;
    }

    private static void createRestrictedDescriptor(FieldInfo fieldInfo, JSourceCode jSourceCode) {
        jSourceCode.add("desc = (XMLFieldDescriptorImpl) getFieldDescriptor(\"");
        jSourceCode.append(fieldInfo.getNodeName());
        jSourceCode.append("\"");
        if (fieldInfo.getNodeType() == 1) {
            jSourceCode.append(", NodeType.Element);");
        } else if (fieldInfo.getNodeType() == 0) {
            jSourceCode.append(", NodeType.Attribute);");
        }
        DescriptorSourceFactory.validationCode(fieldInfo, jSourceCode);
    }

    private static void createDescriptor(DescriptorJClass descriptorJClass, FieldInfo fieldInfo, String string, String string2, JSourceCode jSourceCode) {
        Object object;
        XSType xSType = fieldInfo.getSchemaType();
        boolean bl = false;
        boolean bl2 = fieldInfo.getNodeType() == 1;
        boolean bl3 = fieldInfo.getNodeType() == 0;
        boolean bl4 = fieldInfo.getNodeType() == 2;
        jSourceCode.add("//-- ");
        jSourceCode.append(fieldInfo.getName());
        if (fieldInfo.getName().equals("_anyObject")) {
            bl = true;
        }
        if (xSType.getType() == 45) {
            xSType = ((CollectionInfo)fieldInfo).getContent().getSchemaType();
        }
        String string3 = fieldInfo.getNodeName();
        String string4 = null;
        if (string3 != null && !bl4) {
            string4 = "\"" + string3 + "\"";
            if (SourceGenerator.classDescFieldNames()) {
                string4 = fieldInfo.getNodeName().toUpperCase();
                object = new JModifiers();
                ((JModifiers)object).makePublic();
                ((JModifiers)object).setStatic(true);
                ((JModifiers)object).setFinal(true);
                JField jField = new JField(SGTypes.String, string4);
                jField.setModifiers((JModifiers)object);
                jField.setInitString("\"" + string3 + "\"");
                descriptorJClass.addMember(jField);
            }
        }
        jSourceCode.add("desc = new XMLFieldDescriptorImpl(");
        jSourceCode.append(DescriptorSourceFactory.classType(xSType.getJType()));
        jSourceCode.append(", \"");
        jSourceCode.append(fieldInfo.getName());
        jSourceCode.append("\", ");
        if (string4 != null) {
            jSourceCode.append(string4);
        } else if (bl4) {
            jSourceCode.append("\"PCDATA\"");
        } else {
            jSourceCode.append("(String)null");
        }
        if (bl2) {
            jSourceCode.append(", NodeType.Element);");
        } else if (bl3) {
            jSourceCode.append(", NodeType.Attribute);");
        } else if (bl4) {
            jSourceCode.append(", NodeType.Text);");
        }
        switch (xSType.getType()) {
            case 1: {
                jSourceCode.add("desc.setImmutable(true);");
                break;
            }
            case 26: {
                jSourceCode.add("desc.setReference(true);");
                break;
            }
            case 25: {
                jSourceCode.add("this.identity = desc;");
                break;
            }
            case 18: {
                jSourceCode.add("desc.setSchemaType(\"QName\");");
            }
        }
        DescriptorSourceFactory.createXMLFieldHandler(fieldInfo, xSType, string, jSourceCode);
        if (fieldInfo.isContainer()) {
            jSourceCode.add("desc.setContainer(true);");
            object = xSType.getName();
            if (((String)object).equals(string)) {
                jSourceCode.add("desc.setClassDescriptor(this);");
            } else {
                jSourceCode.add("desc.setClassDescriptor(new " + (String)object + DESCRIPTOR_NAME + "());");
            }
        }
        if (fieldInfo.getNamespaceURI() != null) {
            string2 = fieldInfo.getNamespaceURI();
        }
        if (bl && fieldInfo.getNamespaceURI() == null) {
            string2 = null;
        }
        if (bl2 && string2 != null) {
            jSourceCode.add("desc.setNameSpaceURI(\"");
            jSourceCode.append(string2);
            jSourceCode.append("\");");
        }
        if (fieldInfo.isRequired()) {
            jSourceCode.add("desc.setRequired(true);");
        }
        if (bl) {
            jSourceCode.add("desc.setMatches(\"*\");");
        }
        if (bl2) {
            jSourceCode.add("desc.setMultivalued(" + fieldInfo.isMultivalued());
            jSourceCode.append(");");
        }
        jSourceCode.add("addFieldDescriptor(desc);");
        jSourceCode.add("");
        DescriptorSourceFactory.validationCode(fieldInfo, jSourceCode);
    }

    private static void createXMLFieldHandler(FieldInfo fieldInfo, XSType xSType, String string, JSourceCode jSourceCode) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        if (fieldInfo.getName().equals("_anyObject")) {
            bl2 = true;
        }
        boolean bl4 = bl = fieldInfo.getNodeType() == 0;
        if (xSType.getType() == 0) {
            bl3 = ((XSClass)xSType).isEnumerated();
        }
        jSourceCode.add("handler = (new XMLFieldHandler() {");
        jSourceCode.indent();
        jSourceCode.add("public java.lang.Object getValue( java.lang.Object object ) ");
        jSourceCode.indent();
        jSourceCode.add("throws IllegalStateException");
        jSourceCode.unindent();
        jSourceCode.add("{");
        jSourceCode.indent();
        jSourceCode.add(string);
        jSourceCode.append(" target = (");
        jSourceCode.append(string);
        jSourceCode.append(") object;");
        if (!xSType.isEnumerated() && xSType.getJType().isPrimitive() && !fieldInfo.isMultivalued()) {
            jSourceCode.add("if(!target." + fieldInfo.getHasMethodName() + "())");
            jSourceCode.indent();
            jSourceCode.add("return null;");
            jSourceCode.unindent();
        }
        jSourceCode.add("return ");
        String string2 = "target." + fieldInfo.getReadMethodName() + "()";
        if (fieldInfo.isMultivalued()) {
            jSourceCode.append(string2);
        } else {
            jSourceCode.append(xSType.createToJavaObjectCode(string2));
        }
        jSourceCode.append(";");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("public void setValue( java.lang.Object object, java.lang.Object value) ");
        jSourceCode.indent();
        jSourceCode.add("throws IllegalStateException, IllegalArgumentException");
        jSourceCode.unindent();
        jSourceCode.add("{");
        jSourceCode.indent();
        jSourceCode.add("try {");
        jSourceCode.indent();
        jSourceCode.add(string);
        jSourceCode.append(" target = (");
        jSourceCode.append(string);
        jSourceCode.append(") object;");
        if (xSType.isPrimitive() && !SourceGenerator.usePrimitiveWrapper()) {
            if (!(fieldInfo.isRequired() || xSType.isEnumerated() || fieldInfo.isMultivalued())) {
                jSourceCode.add("// if null, use delete method for optional primitives ");
                jSourceCode.add("if (value == null) {");
                jSourceCode.indent();
                jSourceCode.add("target.");
                jSourceCode.append(fieldInfo.getDeleteMethodName());
                jSourceCode.append("();");
                jSourceCode.add("return;");
                jSourceCode.unindent();
                jSourceCode.add("}");
            } else {
                jSourceCode.add("// ignore null values for non optional primitives");
                jSourceCode.add("if (value == null) return;");
                jSourceCode.add("");
            }
        }
        jSourceCode.add("target.");
        jSourceCode.append(fieldInfo.getWriteMethodName());
        jSourceCode.append("( ");
        if (xSType.isPrimitive() && !SourceGenerator.usePrimitiveWrapper()) {
            jSourceCode.append(xSType.createFromJavaObjectCode("value"));
        } else if (bl2) {
            jSourceCode.append(" value ");
        } else {
            jSourceCode.append("(");
            jSourceCode.append(xSType.getJType().toString());
            if (bl && xSType.isDateTime() && xSType.getType() != 3) {
                jSourceCode.append(".parse");
                jSourceCode.append(JavaNaming.toJavaClassName(xSType.getName()));
                jSourceCode.append("((String) value))");
            } else {
                jSourceCode.append(") value");
            }
        }
        jSourceCode.append(");");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("catch (Exception ex) {");
        jSourceCode.indent();
        jSourceCode.add("throw new IllegalStateException(ex.toString());");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("public java.lang.Object newInstance( java.lang.Object parent ) {");
        jSourceCode.indent();
        jSourceCode.add("return ");
        if (bl2 || bl3 || xSType.isPrimitive() || xSType.getJType().isArray() || xSType.getType() == 1) {
            jSourceCode.append("null;");
        } else {
            jSourceCode.append(xSType.newInstanceCode());
        }
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.unindent();
        jSourceCode.add("} );");
        if (bl3) {
            jSourceCode.add("desc.setHandler( new EnumFieldHandler(");
            jSourceCode.append(DescriptorSourceFactory.classType(xSType.getJType()));
            jSourceCode.append(", handler));");
            jSourceCode.add("desc.setImmutable(true);");
        } else if (xSType.getType() == 3) {
            jSourceCode.add("desc.setHandler( new DateFieldHandler(");
            jSourceCode.append("handler));");
            jSourceCode.add("desc.setImmutable(true);");
        } else if (xSType.getType() == 16) {
            jSourceCode.add("desc.setHandler(handler);");
            jSourceCode.add("desc.setImmutable(true);");
        } else if (fieldInfo.getSchemaType().getType() == 45) {
            switch (xSType.getType()) {
                case 30: 
                case 31: {
                    jSourceCode.add("desc.setHandler( new CollectionFieldHandler(");
                    jSourceCode.append("handler, new NameValidator(NameValidator.NMTOKEN)));");
                    break;
                }
                case 26: 
                case 27: {
                    jSourceCode.add("desc.setMultivalued(" + fieldInfo.isMultivalued());
                    jSourceCode.append(");");
                }
                default: {
                    jSourceCode.add("desc.setHandler(handler);");
                    break;
                }
            }
        } else {
            jSourceCode.add("desc.setHandler(handler);");
        }
    }

    private static void validationCode(FieldInfo fieldInfo, JSourceCode jSourceCode) {
        if (fieldInfo == null) {
            return;
        }
        if (jSourceCode == null) {
            return;
        }
        jSourceCode.add("//-- validation code for: ");
        jSourceCode.append(fieldInfo.getName());
        jSourceCode.add("fieldValidator = new FieldValidator();");
        if (fieldInfo.getName().equals("_anyObject")) {
            jSourceCode.add("desc.setValidator(fieldValidator);");
            return;
        }
        XSType xSType = fieldInfo.getSchemaType();
        if (xSType.getType() == 45) {
            XSList xSList = (XSList)xSType;
            CollectionInfo collectionInfo = (CollectionInfo)fieldInfo;
            FieldInfo fieldInfo2 = collectionInfo.getContent();
            jSourceCode.add("fieldValidator.setMinOccurs(");
            jSourceCode.append(Integer.toString(xSList.getMinimumSize()));
            jSourceCode.append(");");
            if (xSList.getMaximumSize() > 0) {
                jSourceCode.add("fieldValidator.setMaxOccurs(");
                jSourceCode.append(Integer.toString(xSList.getMaximumSize()));
                jSourceCode.append(");");
            }
            if ((xSType = ((CollectionInfo)fieldInfo).getContent().getSchemaType()).getType() == 30) {
                return;
            }
        } else if (fieldInfo.isRequired()) {
            jSourceCode.add("fieldValidator.setMinOccurs(1);");
        }
        jSourceCode.add("{ //-- local scope");
        jSourceCode.indent();
        xSType.validationCode(jSourceCode, fieldInfo.getFixedValue(), FIELD_VALIDATOR_NAME);
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("desc.setValidator(fieldValidator);");
    }

    private static String classType(JType jType) {
        if (jType.isPrimitive()) {
            if (jType == JType.Int) {
                return "java.lang.Integer.TYPE";
            }
            if (jType == JType.Double) {
                return "java.lang.Double.TYPE";
            }
            if (jType == JType.Boolean) {
                return "java.lang.Boolean.TYPE";
            }
        }
        return jType.toString() + ".class";
    }
}

