/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.exolab.castor.persist.LRU;

public abstract class LRU {
    public static final int CACHE_NONE = 1;
    public static final int CACHE_COUNT_LIMITED = 2;
    public static final int CACHE_TIME_LIMITED = 3;
    public static final int CACHE_UNLIMITED = 4;
    public static final int DEFAULT_TYPE = 2;
    public static final int DEFAULT_PARAM = 30;

    public abstract Object put(Object var1, Object var2);

    public abstract Object get(Object var1);

    public abstract Object remove(Object var1);

    public abstract Enumeration elements();

    public static LRU create(int n, int n2) {
        LRU lRU;
        if (n == 0) {
            n = 2;
            n2 = 30;
        }
        switch (n) {
            case 2: {
                if (n2 > 0) {
                    lRU = new CountLimited(n2);
                    break;
                }
                lRU = new NoCache();
                break;
            }
            case 3: {
                if (n2 > 0) {
                    lRU = new TimeLimited(n2);
                    break;
                }
                lRU = new NoCache();
                break;
            }
            case 4: {
                lRU = new Unlimited();
                break;
            }
            case 1: {
                lRU = new NoCache();
                break;
            }
            default: {
                lRU = new CountLimited(100);
            }
        }
        return lRU;
    }

    public static int mapType(String string) {
        if (string == null || string.equals("")) {
            return 0;
        }
        if (string.toLowerCase().equals("none")) {
            return 1;
        }
        if (string.toLowerCase().equals("count-limited")) {
            return 2;
        }
        if (string.toLowerCase().equals("time-limited")) {
            return 3;
        }
        if (string.toLowerCase().equals("unlimited")) {
            return 4;
        }
        return 0;
    }

    public static class Unlimited
    extends LRU {
        private Hashtable map = new Hashtable();

        public Object put(Object object, Object object2) {
            return this.map.put(object, object2);
        }

        public Object get(Object object) {
            return this.map.get(object);
        }

        public Object remove(Object object) {
            return this.map.remove(object);
        }

        public Enumeration elements() {
            return this.map.elements();
        }

        protected void dispose(Object object) {
        }
    }

    public static class TimeLimited
    extends LRU {
        public static final int DEFAULT_PRECISION = 1000;
        private static TimeThread ticker = new TimeThread(1000);
        private int interval;
        private int tailtime;
        private QueueItem head;
        private QueueItem tail;
        private Hashtable map = new Hashtable();

        public TimeLimited(int n) {
            this.interval = n + 1;
            ticker.addListener(this);
        }

        public synchronized Object put(Object object, Object object2) {
            QueueItem queueItem = (QueueItem)this.map.get(object);
            if (queueItem != null) {
                Object object3 = queueItem.item;
                queueItem.item = object2;
                this.remove(queueItem);
                this.add(queueItem);
                return object3;
            }
            QueueItem queueItem2 = new QueueItem(object, object2);
            this.map.put(object, queueItem2);
            this.add(queueItem2);
            return null;
        }

        public synchronized Object get(Object object) {
            Object v = this.map.get(object);
            if (v == null) {
                return null;
            }
            return ((QueueItem)v).item;
        }

        public synchronized Object remove(Object object) {
            Object v = this.map.remove(object);
            if (v == null) {
                return null;
            }
            return ((QueueItem)v).item;
        }

        public synchronized Enumeration elements() {
            return new ValuesEnumeration(this.map.elements());
        }

        protected void dispose(Object object) {
        }

        private void remove(QueueItem queueItem) {
            if (queueItem == null) {
                throw new NullPointerException();
            }
            if (queueItem == this.head) {
                QueueItem queueItem2 = queueItem;
                this.head = this.head.next;
                if (this.head == null) {
                    this.tail = null;
                } else {
                    this.head.prev = null;
                    this.head.time += queueItem2.time;
                }
                queueItem2.prev = null;
                queueItem2.next = null;
                queueItem2.time = 0;
            } else if (queueItem == this.tail) {
                this.tail = this.tail.prev;
                this.tailtime = 0;
            } else {
                QueueItem queueItem3 = queueItem;
                queueItem3.prev.next = queueItem3.next;
                queueItem3.next.prev = queueItem3.prev;
                queueItem3.next.time += queueItem3.time;
                queueItem3.prev = null;
                queueItem3.next = null;
                queueItem3.time = 0;
            }
        }

        private void add(QueueItem queueItem) {
            ticker.startTick();
            if (this.head == null) {
                this.head = this.tail = queueItem;
                queueItem.prev = null;
                queueItem.next = null;
                queueItem.time = this.interval;
                this.tailtime = this.interval;
            } else {
                this.tail.next = queueItem;
                queueItem.prev = this.tail;
                queueItem.next = null;
                queueItem.time = this.interval - this.tailtime;
                this.tailtime = this.interval;
                this.tail = queueItem;
            }
        }

        private synchronized void tick() {
            if (this.head != null) {
                this.head.time--;
                --this.tailtime;
            }
            while (this.head != null && this.head.time <= 0) {
                QueueItem queueItem = this.head;
                Object object = this.head.item;
                this.remove(queueItem);
                this.map.remove(queueItem.key);
                this.dispose(object);
            }
        }

        private static class Test {
            private Test() {
            }

            public static void main(String[] stringArray) throws Exception {
                class TestLRU
                extends TimeLimited {
                    public TestLRU(int n) {
                        super(n);
                    }

                    protected void dispose(Object object) {
                        Enumeration enumeration = this.elements();
                        System.out.println("disposing: " + object);
                        System.out.println("list after disposed!");
                        while (enumeration.hasMoreElements()) {
                            System.out.print(enumeration.nextElement() + "\t");
                        }
                        System.out.println();
                        super.dispose(object);
                    }
                }
                TestLRU testLRU = new TestLRU(5);
                Thread thread = Thread.currentThread();
                Enumeration enumeration = testLRU.elements();
                System.out.println("<empty>");
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("</empty>");
                System.out.println("<put(a,a)>");
                testLRU.put("a", "#a");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                Thread.sleep(1000L);
                System.out.println("\n</put(a,a)>");
                System.out.println("<put[a,b,c,d,e,f,g,h]>");
                testLRU.put("a", "#a");
                System.out.println("put a");
                Thread.sleep(10L);
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println();
                testLRU.put("b", "#b");
                System.out.println("put b");
                Thread.sleep(100L);
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println();
                testLRU.put("c", "#c");
                System.out.println("put c");
                Thread.sleep(1000L);
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println();
                testLRU.put("d", "#d");
                System.out.println("put d");
                Thread.sleep(500L);
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println();
                testLRU.put("e", "#e");
                System.out.println("put e");
                Thread.sleep(1000L);
                testLRU.put("f", "#f");
                System.out.println("put f");
                Thread.sleep(1000L);
                testLRU.put("g", "#g");
                System.out.println("put g");
                Thread.sleep(1000L);
                testLRU.put("h", "#h");
                System.out.println("put h");
                Thread.sleep(500L);
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println();
                int n = 0;
                while (n < 10) {
                    Thread.sleep(1000L);
                    enumeration = testLRU.elements();
                    while (enumeration.hasMoreElements()) {
                        System.out.print(enumeration.nextElement() + "\t");
                    }
                    System.out.println();
                    ++n;
                }
                System.out.println("\n</put[a,b,c,d,e,f,g,h]>");
            }
        }

        private static class TimeThread
        extends Thread {
            private int[] listenerLock = new int[0];
            private LinkList listener;
            private int[] lock = new int[0];
            private int tick;
            private long lastTime;
            private boolean isStopped;
            private boolean isStarted;

            public TimeThread(int n) {
                super("Time-limited cache daemon");
                this.tick = n;
                this.setDaemon(true);
                this.setPriority(1);
                this.isStopped = true;
                this.start();
            }

            public void startTick() {
                if (this.isStarted && this.isStopped) {
                    int[] nArray = this.lock;
                    synchronized (nArray) {
                        this.lastTime = System.currentTimeMillis();
                        this.lock.notify();
                    }
                }
            }

            public void stopTick() {
                this.isStopped = true;
            }

            public void run() {
                this.isStarted = true;
                try {
                    block5: while (true) {
                        Object object;
                        if (this.isStopped) {
                            object = this.lock;
                            synchronized (object) {
                                this.lock.wait();
                            }
                            this.isStopped = false;
                        } else {
                            long l = System.currentTimeMillis();
                            if (l - this.lastTime < (long)this.tick) {
                                Thread.sleep((long)this.tick - (l - this.lastTime));
                            }
                            this.lastTime = l;
                        }
                        object = this.listener;
                        while (true) {
                            if (object == null) continue block5;
                            ((LinkList)object).t.tick();
                            object = ((LinkList)object).next;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }

            public void addListener(TimeLimited timeLimited) {
                int[] nArray = this.listenerLock;
                synchronized (nArray) {
                    this.listener = new LinkList(this.listener, timeLimited);
                }
            }

            private class LinkList {
                private LinkList next;
                private TimeLimited t;

                LinkList(LinkList linkList, TimeLimited timeLimited) {
                    this.next = linkList;
                    this.t = timeLimited;
                }
            }
        }

        private class QueueItem {
            private QueueItem next;
            private QueueItem prev;
            private Object key;
            private Object item;
            private int time;

            private QueueItem(Object object, Object object2) {
                this.key = object;
                this.item = object2;
            }
        }

        private class ValuesEnumeration
        implements Enumeration {
            private Vector v = new Vector();
            private int cur;

            private ValuesEnumeration(Enumeration enumeration) {
                while (enumeration.hasMoreElements()) {
                    this.v.add(enumeration.nextElement());
                }
                this.v.trimToSize();
            }

            public boolean hasMoreElements() {
                return this.v.size() > this.cur;
            }

            public Object nextElement() throws NoSuchElementException {
                Object e;
                if (this.v.size() <= this.cur) {
                    throw new NoSuchElementException();
                }
                if ((e = this.v.get(this.cur++)) != null) {
                    return ((QueueItem)e).item;
                }
                return null;
            }
        }
    }

    public static class NoCache
    extends LRU {
        public synchronized Object put(Object object, Object object2) {
            this.dispose(object2);
            return null;
        }

        public synchronized Object get(Object object) {
            return null;
        }

        public synchronized Object remove(Object object) {
            return null;
        }

        public Enumeration elements() {
            return new EmptyEnumeration();
        }

        protected void dispose(Object object) {
        }

        private class EmptyEnumeration
        implements Enumeration {
            private EmptyEnumeration() {
            }

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() throws NoSuchElementException {
                throw new NoSuchElementException();
            }
        }
    }

    public static class CountLimited
    extends LRU {
        private static final int LRU_OLD = 0;
        private static final int LRU_NEW = 1;
        private Hashtable mapKeyPos;
        private Object[] keys;
        private Object[] values;
        private int[] status;
        private int cur;
        private int size;

        public CountLimited(int n) {
            this.keys = new Object[n];
            this.values = new Object[n];
            this.status = new int[n];
            this.mapKeyPos = new Hashtable(n);
            this.size = n;
        }

        public synchronized Object put(Object object, Object object2) {
            Object v = this.mapKeyPos.get(object);
            if (v != null) {
                int n = (Integer)v;
                Object object3 = this.values[n];
                this.values[n] = object2;
                this.status[n] = 1;
                this.dispose(object3);
                return object3;
            }
            while (this.walkStatus() != 0) {
            }
            Integer n = this.keys[this.cur] != null ? this.mapKeyPos.remove(this.keys[this.cur]) : new Integer(this.cur);
            Object object4 = this.values[this.cur];
            this.keys[this.cur] = object;
            this.values[this.cur] = object2;
            this.status[this.cur] = 1;
            this.mapKeyPos.put(object, n);
            ++this.cur;
            if (this.cur >= this.size) {
                this.cur = 0;
            }
            if (object4 != null) {
                this.dispose(object4);
            }
            return object4;
        }

        public synchronized Object get(Object object) {
            Object v = this.mapKeyPos.get(object);
            if (v != null) {
                int n = (Integer)v;
                this.status[n] = 1;
                return this.values[n];
            }
            return null;
        }

        public synchronized Object remove(Object object) {
            Object v = this.mapKeyPos.remove(object);
            if (v != null) {
                int n = (Integer)v;
                Object object2 = this.values[n];
                this.keys[n] = null;
                this.values[n] = null;
                this.status[n] = 0;
                return object2;
            }
            return null;
        }

        public Enumeration elements() {
            return new ValuesEnumeration(this.values);
        }

        protected void dispose(Object object) {
        }

        private int walkStatus() {
            int n = this.status[this.cur];
            if (this.status[this.cur] == 1) {
                this.status[this.cur] = 0;
                ++this.cur;
                if (this.cur >= this.size) {
                    this.cur = 0;
                }
                return 1;
            }
            return 0;
        }

        private static class Test {
            private Test() {
            }

            public static void main(String[] stringArray) {
                class TestLRU
                extends CountLimited {
                    public TestLRU(int n) {
                        super(n);
                    }

                    protected void dispose(Object object) {
                    }
                }
                TestLRU testLRU = new TestLRU(3);
                Enumeration enumeration = testLRU.elements();
                System.out.println("<empty>");
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("</empty>");
                System.out.println("<put(a,a)>");
                testLRU.put("a", "#a");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</put(a,a)>");
                System.out.println("<put(b,b)>");
                testLRU.put("b", "#b");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</put(b,b)>");
                System.out.println("<put(c,c)>");
                testLRU.put("c", "#c");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</put(c,c)>");
                System.out.println("<put(d,d)>");
                testLRU.put("d", "#d");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</put(d,d)>");
                System.out.println("<put(c,c1)>");
                testLRU.put("c", "#c1");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</put(c,c1)>");
                System.out.println("<put(c,c2)>");
                testLRU.put("c", "#c2");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</put(c,c2)>");
                System.out.println("<put(c,c3)>");
                testLRU.put("c", "#c3");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</put(c,c3)>");
                System.out.println("<put(b,b)>");
                testLRU.put("b", "#b");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</put(b,b)>");
                System.out.println("<put(e,e)>");
                testLRU.put("e", "#e");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</put(e,e)>");
                System.out.println("<put(f,f)>");
                testLRU.put("f", "#f");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</put(f,f)>");
                System.out.println("<remove(e,e)>");
                System.out.println(testLRU.remove("e") + " is removed!");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</remove(e,e)>");
                System.out.println("<put(g,g)>");
                testLRU.put("g", "#g");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</put(g,g)>");
                System.out.println("<remove(f,f)>");
                System.out.println(testLRU.remove("f") + " is removed!");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</remove(f,f)>");
                System.out.println("<remove(b,b)>");
                System.out.println(testLRU.remove("b") + " is removed!");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</remove(b,b)>");
                System.out.println("<remove(g,g)>");
                System.out.println(testLRU.remove("g") + " is removed!");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</remove(g,g)>");
                System.out.println("<remove(x,x)>");
                System.out.println(testLRU.remove("x") + " is removed!");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</remove(x,x)>");
                System.out.println("<put(a,a)>");
                testLRU.put("a", "#a");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</put(a,a)>");
                System.out.println("<put(b,b)>");
                testLRU.put("b", "#b");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</put(b,b)>");
                System.out.println("<put(c,c)>");
                testLRU.put("c", "#c");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</put(c,c)>");
                System.out.println("<put(d,d)>");
                testLRU.put("d", "#d");
                enumeration = testLRU.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement() + "\t");
                }
                System.out.println("\n</put(d,d)>");
            }
        }

        private class ValuesEnumeration
        implements Enumeration {
            private int cur;
            private Object[] values;

            private ValuesEnumeration(Object[] objectArray) {
                Vector<Object> vector = new Vector<Object>(objectArray.length);
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] != null) {
                        vector.add(objectArray[n]);
                    }
                    ++n;
                }
                this.values = vector.toArray();
            }

            public boolean hasMoreElements() {
                return this.values != null && this.values.length > this.cur;
            }

            public Object nextElement() throws NoSuchElementException {
                if (this.values == null || this.values.length <= this.cur) {
                    throw new NoSuchElementException();
                }
                return this.values[this.cur++];
            }
        }
    }
}

