/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.transaction.xa.Xid;
import org.exolab.castor.jdo.ClassNotPersistenceCapableException;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.ObjectNotPersistentException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.ObjectDeletedWaitingForLockException;
import org.exolab.castor.persist.ObjectLock;
import org.exolab.castor.persist.PersistenceInfoGroup;
import org.exolab.castor.persist.QueryResults;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.InstanceFactory;
import org.exolab.castor.persist.spi.PersistenceQuery;
import org.exolab.castor.util.Messages;

public abstract class TransactionContext {
    public static int OBJECT_STATE_TRANSIENT = 0;
    public static int OBJECT_STATE_HOLLOW = 1;
    public static int OBJECT_STATE_READ_ONLY = 2;
    public static int OBJECT_STATE_PERSISTENT = 3;
    public static int OBJECT_STATE_PERSISTENT_NEW = 4;
    public static int OBJECT_STATE_PERSISTENT_DELETED = 5;
    public static int OBJECT_STATE_PERSISTENT_NEW_DELETED = 6;
    private ObjectLock _waitOnLock;
    private final Vector _objects = new Vector();
    private final Hashtable _engineOids = new Hashtable();
    private final Hashtable _readOnlyObjects = new Hashtable();
    private int _status;
    private int _lockTimeout = 30;
    private final Xid _xid;
    private int _txTimeout = 30;
    private ObjectEntry _deletedList;
    private Database _db;
    private boolean _autoStore;
    private CallbackInterceptor _callback;
    private InstanceFactory _instanceFactory;
    private boolean _creating;

    public TransactionContext(Database database) {
        this._xid = null;
        this._status = 0;
        this._db = database;
    }

    public TransactionContext(Database database, Xid xid) {
        this._xid = xid;
        this._status = 0;
        this._db = database;
    }

    public void setAutoStore(boolean bl) {
        this._autoStore = bl;
    }

    public boolean isAutoStore() {
        return this._autoStore;
    }

    public void setCallback(CallbackInterceptor callbackInterceptor) {
        this._callback = callbackInterceptor;
    }

    public void setInstanceFactory(InstanceFactory instanceFactory) {
        this._instanceFactory = instanceFactory;
    }

    public PersistenceInfoGroup getScope() {
        return this._db.getScope();
    }

    public void setTransactionTimeout(int n) {
        this._txTimeout = n;
    }

    public int getTransactionTimeout() {
        return this._txTimeout;
    }

    public int getLockTimeout() {
        return this._lockTimeout;
    }

    public void setLockTimeout(int n) {
        this._lockTimeout = n >= 0 ? n : 0;
    }

    public abstract Object getConnection(LockEngine var1) throws PersistenceException;

    protected abstract void commitConnections() throws TransactionAbortedException;

    protected abstract void closeConnections() throws TransactionAbortedException;

    protected abstract void rollbackConnections();

    public synchronized Object fetch(LockEngine lockEngine, ClassMolder classMolder, Object object, AccessMode accessMode) throws ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        ObjectEntry objectEntry = null;
        if (object == null) {
            throw new PersistenceException("Identities can't be null!");
        }
        OID oID = new OID(lockEngine, classMolder, object);
        AccessMode accessMode2 = classMolder.getAccessMode(accessMode);
        if (accessMode2 == AccessMode.ReadOnly) {
            objectEntry = this.getReadOnlyObjectEntry(oID);
        }
        if (objectEntry == null) {
            objectEntry = this.getObjectEntry(lockEngine, oID);
        }
        if (objectEntry != null) {
            if (objectEntry.engine != lockEngine) {
                throw new PersistenceException(Messages.format("persist.multipleLoad", classMolder.getName(), object));
            }
            if (objectEntry.deleted) {
                return null;
            }
            if (!classMolder.isAssignableFrom(objectEntry.object.getClass())) {
                throw new PersistenceException(Messages.format("persist.typeMismatch", classMolder.getName(), object));
            }
            if (objectEntry.created) {
                return objectEntry.object;
            }
            if (!(accessMode2 != AccessMode.Exclusive && accessMode2 != AccessMode.DbLocked || objectEntry.oid.isDbLock())) {
                throw new PersistenceException(Messages.format("persist.lockConflict", classMolder.getName(), object));
            }
            return objectEntry.object;
        }
        return null;
    }

    public synchronized Object load(LockEngine lockEngine, ClassMolder classMolder, Object object, Object object2, AccessMode accessMode) throws ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        return this.load(lockEngine, classMolder, object, object2, accessMode, null);
    }

    public synchronized Object load(LockEngine lockEngine, ClassMolder classMolder, Object object, Object object2, AccessMode accessMode, QueryResults queryResults) throws ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        ObjectEntry objectEntry = null;
        Object object3 = null;
        if (object == null) {
            throw new PersistenceException("Identities can't be null!");
        }
        OID oID = new OID(lockEngine, classMolder, object);
        if (object2 != null && !classMolder.getJavaClass(this._db.getClassLoader()).isAssignableFrom(object2.getClass())) {
            throw new PersistenceException(Messages.format("persist.typeMismatch", classMolder.getName(), object2.getClass()));
        }
        AccessMode accessMode2 = classMolder.getAccessMode(accessMode);
        if (accessMode2 == AccessMode.ReadOnly) {
            objectEntry = this.getReadOnlyObjectEntry(oID);
        }
        if (objectEntry == null) {
            objectEntry = this.getObjectEntry(lockEngine, oID);
        }
        if (objectEntry != null) {
            if (object2 != null && object2 != objectEntry.object) {
                throw new PersistenceException(Messages.format("persist.multipleLoad", classMolder.getName(), object));
            }
            if (objectEntry.engine != lockEngine) {
                throw new PersistenceException(Messages.format("persist.multipleLoad", classMolder.getName(), object));
            }
            if (objectEntry.deleted) {
                throw new ObjectNotFoundException("Object is deleted" + classMolder.getName() + object);
            }
            if (!classMolder.getJavaClass(this._db.getClassLoader()).isAssignableFrom(objectEntry.object.getClass())) {
                throw new PersistenceException(Messages.format("persist.typeMismatch", classMolder.getName(), objectEntry.object.getClass()));
            }
            if (objectEntry.created) {
                return objectEntry.object;
            }
            if (!(accessMode2 != AccessMode.Exclusive && accessMode2 != AccessMode.DbLocked || objectEntry.oid.isDbLock())) {
                throw new PersistenceException(Messages.format("persist.lockConflict", classMolder.getName(), object));
            }
            return objectEntry.object;
        }
        try {
            object3 = object2 != null ? object2 : (this._instanceFactory != null ? this._instanceFactory.newInstance(classMolder.getName(), this._db.getClassLoader()) : classMolder.newInstance(this._db.getClassLoader()));
            objectEntry = this.addObjectEntry(oID, object3);
            oID = lockEngine.load(this, oID, object3, accessMode, this._lockTimeout, queryResults);
            objectEntry = this.rehash(object3, oID);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            this.removeObjectEntry(object3);
            throw objectNotFoundException;
        }
        catch (LockNotGrantedException lockNotGrantedException) {
            this.removeObjectEntry(object3);
            throw lockNotGrantedException;
        }
        catch (ClassNotPersistenceCapableException classNotPersistenceCapableException) {
            this.removeObjectEntry(object3);
            throw new PersistenceException(Messages.format("persist.nested", classNotPersistenceCapableException));
        }
        try {
            if (this._callback != null) {
                this._callback.using(object3, this._db);
                this._callback.loaded(object3, TransactionContext.toDatabaseAccessMode(accessMode2));
            } else if (classMolder.getCallback() != null) {
                classMolder.getCallback().using(object3, this._db);
                classMolder.getCallback().loaded(object3, TransactionContext.toDatabaseAccessMode(accessMode2));
            }
        }
        catch (Exception exception) {
            this.release(object3);
            throw new PersistenceException(Messages.format("persist.nested", exception));
        }
        if (accessMode2 == AccessMode.ReadOnly) {
            this.makeReadOnly(object3);
        }
        return object3;
    }

    public synchronized QueryResults query(LockEngine lockEngine, PersistenceQuery persistenceQuery, AccessMode accessMode, boolean bl) throws QueryException, PersistenceException {
        persistenceQuery.execute(this.getConnection(lockEngine), accessMode, bl);
        return new QueryResults(this, lockEngine, persistenceQuery, accessMode, this._db);
    }

    public synchronized QueryResults query(LockEngine lockEngine, PersistenceQuery persistenceQuery, AccessMode accessMode) throws QueryException, PersistenceException {
        return this.query(lockEngine, persistenceQuery, accessMode, false);
    }

    public synchronized void markCreate(LockEngine lockEngine, ClassMolder classMolder, Object object, OID oID) throws DuplicateIdentityException, PersistenceException {
        if (object == null) {
            throw new NullPointerException();
        }
        Object object2 = classMolder.getIdentity(this, object);
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (this._autoStore && objectEntry != null && objectEntry.object == object) {
            return;
        }
        if (objectEntry != null && !objectEntry.deleted) {
            throw new PersistenceException(Messages.format("persist.objectAlreadyPersistent", object.getClass().getName(), objectEntry.oid.getIdentity()));
        }
        OID oID2 = new OID(lockEngine, classMolder, oID, object2);
        objectEntry = this.getObjectEntry(lockEngine, oID2);
        if (object2 != null && objectEntry != null) {
            if (!objectEntry.deleted || objectEntry.object != object) {
                throw new DuplicateIdentityException(Messages.format("persist.duplicateIdentity", object.getClass().getName(), object2));
            }
            if (this._deletedList != null) {
                if (this._deletedList == objectEntry) {
                    this._deletedList = objectEntry.nextDeleted;
                } else {
                    ObjectEntry objectEntry2 = this._deletedList;
                    while (objectEntry2.nextDeleted != null && objectEntry2.nextDeleted != objectEntry) {
                        objectEntry2 = objectEntry2.nextDeleted;
                    }
                    if (objectEntry2.nextDeleted == objectEntry) {
                        objectEntry2.nextDeleted = objectEntry.nextDeleted;
                    } else {
                        throw new PersistenceException(Messages.format("persist.deletedNotFound", object2));
                    }
                }
            }
        }
        try {
            objectEntry = this.addObjectEntry(oID2, object);
            objectEntry.creating = true;
            if (this._callback != null) {
                this._callback.creating(objectEntry.object, this._db);
            } else if (objectEntry.molder.getCallback() != null) {
                objectEntry.molder.getCallback().creating(objectEntry.object, this._db);
            }
            lockEngine.markCreate(this, oID2, object);
        }
        catch (LockNotGrantedException lockNotGrantedException) {
            this.removeObjectEntry(object);
            throw new DuplicateIdentityException("");
        }
        catch (PersistenceException persistenceException) {
            this.removeObjectEntry(object);
            throw persistenceException;
        }
        catch (Exception exception) {
            this.removeObjectEntry(object);
            throw new PersistenceException(Messages.format("persist.nested", exception));
        }
    }

    public synchronized void create(LockEngine lockEngine, ClassMolder classMolder, Object object, OID oID) throws DuplicateIdentityException, PersistenceException {
        ObjectEntry objectEntry;
        Enumeration enumeration;
        boolean bl = false;
        if (!this._creating) {
            bl = true;
            this._creating = true;
        }
        try {
            this.markCreate(lockEngine, classMolder, object, oID);
        }
        catch (DuplicateIdentityException duplicateIdentityException) {
            if (bl) {
                this._creating = false;
            }
            throw duplicateIdentityException;
        }
        catch (PersistenceException persistenceException) {
            if (bl) {
                this._creating = false;
            }
            throw persistenceException;
        }
        int n = 0;
        int n2 = 0;
        boolean bl2 = bl;
        while (bl2) {
            enumeration = this._objects.elements();
            bl2 = false;
            while (enumeration.hasMoreElements()) {
                objectEntry = (ObjectEntry)enumeration.nextElement();
                try {
                    if (!objectEntry.creating || objectEntry.deleted) continue;
                    if (objectEntry.molder.getPriority() <= n) {
                        OID oID2 = objectEntry.engine.create(this, objectEntry.oid, objectEntry.object);
                        if (oID2.getIdentity() == null) {
                            throw new IllegalStateException("oid.getIdentity() is null after create!");
                        }
                        ObjectEntry objectEntry2 = this.rehash(objectEntry.object, oID2);
                        objectEntry2.created = true;
                        objectEntry2.creating = false;
                        if (this._callback != null) {
                            this._callback.using(objectEntry2.object, this._db);
                            this._callback.created(objectEntry2.object);
                            continue;
                        }
                        if (objectEntry.molder.getCallback() == null) continue;
                        objectEntry.molder.getCallback().using(objectEntry2.object, this._db);
                        objectEntry.molder.getCallback().created(objectEntry2.object);
                        continue;
                    }
                    n2 = Math.min(n + 1, objectEntry.molder.getPriority());
                    bl2 = true;
                }
                catch (Exception exception) {
                    if (this._callback != null) {
                        this._callback.releasing(objectEntry.object, false);
                    } else if (classMolder.getCallback() != null) {
                        classMolder.getCallback().releasing(objectEntry.object, false);
                    }
                    this.removeObjectEntry(objectEntry.object);
                    if (exception instanceof DuplicateIdentityException) {
                        throw (DuplicateIdentityException)exception;
                    }
                    if (exception instanceof PersistenceException) {
                        throw (PersistenceException)exception;
                    }
                    throw new PersistenceException(Messages.format("persist.nested", exception));
                }
            }
            n = n2;
        }
        if (bl) {
            enumeration = this._objects.elements();
            while (enumeration.hasMoreElements()) {
                objectEntry = (ObjectEntry)enumeration.nextElement();
                if (!objectEntry.created || !objectEntry.updateCacheNeeded) continue;
                objectEntry.engine.updateCache(this, objectEntry.oid, objectEntry.object);
                objectEntry.updateCacheNeeded = false;
            }
            this._creating = false;
        }
    }

    public boolean markUpdate(LockEngine lockEngine, ClassMolder classMolder, Object object, OID oID) throws DuplicateIdentityException, ObjectModifiedException, ClassNotPersistenceCapableException, PersistenceException {
        if (object == null) {
            throw new NullPointerException();
        }
        Object object2 = classMolder.getActualIdentity(this, object);
        if (classMolder.isDefaultIdentity(object2)) {
            object2 = null;
        }
        OID oID2 = new OID(lockEngine, classMolder, oID, object2);
        ObjectEntry objectEntry = this.getObjectEntry(lockEngine, oID2);
        if (this._autoStore && objectEntry != null && objectEntry.object == object) {
            return false;
        }
        if (objectEntry != null) {
            if (objectEntry.deleted) {
                throw new ObjectDeletedException(Messages.format("persist.objectDeleted", object.getClass(), object2));
            }
            throw new DuplicateIdentityException("update object which is already in the transaction");
        }
        try {
            objectEntry = this.addObjectEntry(oID2, object);
            objectEntry.creating = objectEntry.engine.update(this, oID2, object, null, 0);
        }
        catch (DuplicateIdentityException duplicateIdentityException) {
            this.removeObjectEntry(object);
            throw duplicateIdentityException;
        }
        catch (PersistenceException persistenceException) {
            this.removeObjectEntry(object);
            throw persistenceException;
        }
        if (!objectEntry.creating) {
            try {
                if (this._callback != null) {
                    this._callback.using(object, this._db);
                    this._callback.updated(object);
                } else if (classMolder.getCallback() != null) {
                    classMolder.getCallback().using(object, this._db);
                    classMolder.getCallback().updated(object);
                }
            }
            catch (Exception exception) {
                this.release(object);
                if (exception instanceof PersistenceException) {
                    throw (PersistenceException)exception;
                }
                throw new PersistenceException(exception.getMessage(), exception);
            }
            return false;
        }
        return true;
    }

    public synchronized void update(LockEngine lockEngine, ClassMolder classMolder, Object object, OID oID) throws DuplicateIdentityException, ObjectModifiedException, ClassNotPersistenceCapableException, PersistenceException {
        ObjectEntry objectEntry;
        Enumeration enumeration;
        boolean bl = false;
        if (!this._creating) {
            bl = true;
            this._creating = true;
        }
        try {
            this.markUpdate(lockEngine, classMolder, object, oID);
        }
        catch (DuplicateIdentityException duplicateIdentityException) {
            if (bl) {
                this._creating = false;
            }
            throw duplicateIdentityException;
        }
        catch (PersistenceException persistenceException) {
            if (bl) {
                this._creating = false;
            }
            throw persistenceException;
        }
        int n = 0;
        int n2 = 0;
        boolean bl2 = bl;
        while (bl2) {
            enumeration = this._objects.elements();
            bl2 = false;
            while (enumeration.hasMoreElements()) {
                objectEntry = (ObjectEntry)enumeration.nextElement();
                try {
                    if (!objectEntry.creating || objectEntry.deleted) continue;
                    if (objectEntry.molder.getPriority() <= n) {
                        if (this._callback != null) {
                            this._callback.creating(objectEntry.object, this._db);
                        } else if (objectEntry.molder.getCallback() != null) {
                            objectEntry.molder.getCallback().creating(objectEntry.object, this._db);
                        }
                        OID oID2 = objectEntry.engine.create(this, objectEntry.oid, objectEntry.object);
                        if (oID2.getIdentity() == null) {
                            throw new IllegalStateException("oid.getIdentity() is null after create!");
                        }
                        ObjectEntry objectEntry2 = this.rehash(objectEntry.object, oID2);
                        objectEntry2.created = true;
                        objectEntry2.creating = false;
                        if (this._callback != null) {
                            this._callback.using(objectEntry2.object, this._db);
                            this._callback.created(objectEntry2.object);
                            continue;
                        }
                        if (objectEntry.molder.getCallback() == null) continue;
                        objectEntry.molder.getCallback().using(objectEntry2.object, this._db);
                        objectEntry.molder.getCallback().created(objectEntry2.object);
                        continue;
                    }
                    n2 = Math.min(n + 1, objectEntry.molder.getPriority());
                    bl2 = true;
                }
                catch (Exception exception) {
                    if (this._callback != null) {
                        this._callback.releasing(objectEntry.object, false);
                    } else if (classMolder.getCallback() != null) {
                        classMolder.getCallback().releasing(objectEntry.object, false);
                    }
                    this.removeObjectEntry(objectEntry.object);
                    if (exception instanceof DuplicateIdentityException) {
                        throw (DuplicateIdentityException)exception;
                    }
                    if (exception instanceof PersistenceException) {
                        throw (PersistenceException)exception;
                    }
                    exception.printStackTrace();
                    throw new PersistenceException(Messages.format("persist.nested", exception));
                }
            }
            n = n2;
        }
        if (bl) {
            enumeration = this._objects.elements();
            while (enumeration.hasMoreElements()) {
                objectEntry = (ObjectEntry)enumeration.nextElement();
                if (!objectEntry.created || !objectEntry.updateCacheNeeded) continue;
                objectEntry.engine.updateCache(this, objectEntry.oid, objectEntry.object);
                objectEntry.updateCacheNeeded = false;
            }
            this._creating = false;
        }
    }

    public synchronized void delete(Object object) throws ObjectNotPersistentException, LockNotGrantedException, PersistenceException {
        if (object == null) {
            throw new PersistenceException("Object to be deleted is null!");
        }
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (objectEntry == null) {
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName()));
        }
        if (objectEntry.deleted) {
            throw new ObjectDeletedException(Messages.format("persist.objectDeleted", object.getClass().getName(), objectEntry.oid.getIdentity()));
        }
        try {
            if (this._callback != null) {
                this._callback.removing(objectEntry.object);
            } else if (objectEntry.molder.getCallback() != null) {
                objectEntry.molder.getCallback().removing(objectEntry.object);
            }
        }
        catch (Exception exception) {
            throw new PersistenceException(Messages.format("persist.nested", exception));
        }
        try {
            objectEntry.deleted = true;
            objectEntry.engine.softLock(this, objectEntry.oid, this._lockTimeout);
            objectEntry.engine.markDelete(this, objectEntry.oid, object, this._lockTimeout);
            if (this._deletedList == null) {
                this._deletedList = objectEntry;
            } else {
                ObjectEntry objectEntry2 = this._deletedList;
                while (objectEntry2.nextDeleted != null) {
                    objectEntry2 = objectEntry2.nextDeleted;
                }
                objectEntry2.nextDeleted = objectEntry;
            }
            try {
                if (this._callback != null) {
                    this._callback.removed(objectEntry.object);
                } else if (objectEntry.molder.getCallback() != null) {
                    objectEntry.molder.getCallback().removed(objectEntry.object);
                }
            }
            catch (Exception exception) {
                throw new PersistenceException(Messages.format("persist.nested", exception));
            }
        }
        catch (ObjectDeletedException objectDeletedException) {
            this.removeObjectEntry(object);
        }
    }

    public synchronized void writeLock(Object object, int n) throws ObjectNotPersistentException, LockNotGrantedException, PersistenceException {
        if (object == null) {
            throw new PersistenceException("Object to acquire lock is null!");
        }
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (objectEntry == null) {
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName()));
        }
        if (objectEntry.deleted) {
            throw new ObjectDeletedException(Messages.format("persist.objectDeleted", object.getClass(), objectEntry.oid.getIdentity()));
        }
        try {
            objectEntry.engine.writeLock(this, objectEntry.oid, n);
        }
        catch (ObjectDeletedException objectDeletedException) {
            this.removeObjectEntry(object);
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName()));
        }
        catch (LockNotGrantedException lockNotGrantedException) {
            throw lockNotGrantedException;
        }
    }

    public synchronized void markModified(Object object, boolean bl, boolean bl2) {
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (objectEntry != null) {
            if (bl) {
                objectEntry.updatePersistNeeded = true;
            }
            if (bl2) {
                objectEntry.updateCacheNeeded = true;
            }
            if (bl || bl2) {
                // empty if block
            }
        }
    }

    public synchronized void softLock(Object object, int n) throws LockNotGrantedException, ObjectNotPersistentException {
        if (object == null) {
            throw new ObjectNotPersistentException("Object to acquire lock is null!");
        }
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (objectEntry == null) {
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName()));
        }
        if (objectEntry.deleted) {
            throw new ObjectDeletedException(Messages.format("persist.objectDeleted", object.getClass().getName(), objectEntry.oid.getIdentity()));
        }
        try {
            objectEntry.engine.softLock(this, objectEntry.oid, n);
        }
        catch (ObjectDeletedWaitingForLockException objectDeletedWaitingForLockException) {
            this.removeObjectEntry(object);
            throw objectDeletedWaitingForLockException;
        }
        catch (LockNotGrantedException lockNotGrantedException) {
            throw lockNotGrantedException;
        }
    }

    public synchronized void release(Object object) throws ObjectNotPersistentException, PersistenceException {
        if (object == null) {
            throw new PersistenceException("Object to release lock is null!");
        }
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (objectEntry == null || objectEntry.deleted) {
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName().getClass()));
        }
        objectEntry.engine.releaseLock(this, objectEntry.oid);
        this.removeObjectEntry(object);
        if (this._callback != null) {
            this._callback.releasing(object, false);
        } else if (objectEntry.molder.getCallback() != null) {
            objectEntry.molder.getCallback().releasing(object, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean prepare() throws TransactionAbortedException {
        boolean bl;
        if (this._status == 1) {
            throw new TransactionAbortedException("persist.markedRollback");
        }
        if (this._status != 0) {
            throw new IllegalStateException(Messages.message("persist.noTransaction"));
        }
        try {
            try {
                if (this._objects.size() != 0) {
                    ObjectEntry objectEntry;
                    Enumeration enumeration;
                    boolean bl2;
                    int n;
                    int n2;
                    Vector<ObjectEntry> vector = new Vector<ObjectEntry>();
                    block10: while (true) {
                        if (this._objects.size() == vector.size()) {
                            n2 = 0;
                            n = 0;
                            bl2 = true;
                            break;
                        }
                        Vector<ObjectEntry> vector2 = new Vector<ObjectEntry>();
                        enumeration = this._objects.elements();
                        while (true) {
                            if (!enumeration.hasMoreElements()) break;
                            objectEntry = (ObjectEntry)enumeration.nextElement();
                            if (vector.contains(objectEntry)) continue;
                            vector2.addElement(objectEntry);
                        }
                        enumeration = vector2.elements();
                        while (true) {
                            OID oID;
                            if (!enumeration.hasMoreElements()) continue block10;
                            objectEntry = (ObjectEntry)enumeration.nextElement();
                            if (!objectEntry.deleted && !objectEntry.creating && (oID = objectEntry.engine.preStore(this, objectEntry.oid, objectEntry.object, this._lockTimeout)) != null) {
                                objectEntry.oid = oID;
                                objectEntry.updateCacheNeeded = true;
                            }
                            vector.addElement(objectEntry);
                        }
                        break;
                    }
                    block13: while (true) {
                        if (!bl2) break;
                        enumeration = this._objects.elements();
                        bl2 = false;
                        while (true) {
                            if (!enumeration.hasMoreElements()) {
                                n2 = n;
                                continue block13;
                            }
                            ObjectEntry objectEntry2 = (ObjectEntry)enumeration.nextElement();
                            try {
                                if (!objectEntry2.creating || objectEntry2.deleted || objectEntry2.created) continue;
                                if (objectEntry2.molder.getPriority() <= n2) {
                                    if (this._callback != null) {
                                        this._callback.creating(objectEntry2.object, this._db);
                                    } else if (objectEntry2.molder.getCallback() != null) {
                                        objectEntry2.molder.getCallback().creating(objectEntry2.object, this._db);
                                    }
                                    OID oID = objectEntry2.engine.create(this, objectEntry2.oid, objectEntry2.object);
                                    if (oID.getIdentity() == null) {
                                        throw new IllegalStateException("oid.getIdentity() is null after create!");
                                    }
                                    objectEntry = this.rehash(objectEntry2.object, oID);
                                    objectEntry.created = true;
                                    if (this._callback != null) {
                                        this._callback.using(objectEntry.object, this._db);
                                        this._callback.created(objectEntry.object);
                                        continue;
                                    }
                                    if (objectEntry2.molder.getCallback() == null) continue;
                                    objectEntry2.molder.getCallback().using(objectEntry.object, this._db);
                                    objectEntry2.molder.getCallback().created(objectEntry.object);
                                    continue;
                                }
                                n = Math.min(n2 + 1, objectEntry2.molder.getPriority());
                                bl2 = true;
                            }
                            catch (Exception exception) {
                                if (this._callback != null) {
                                    this._callback.releasing(objectEntry2.object, false);
                                } else if (objectEntry2.molder.getCallback() != null) {
                                    objectEntry2.molder.getCallback().releasing(objectEntry2.object, false);
                                }
                                this.removeObjectEntry(objectEntry2.object);
                                if (exception instanceof DuplicateIdentityException) {
                                    throw (DuplicateIdentityException)exception;
                                }
                                if (!(exception instanceof PersistenceException)) throw new PersistenceException(Messages.format("persist.nested", exception));
                                throw (PersistenceException)exception;
                            }
                        }
                        break;
                    }
                    enumeration = this._objects.elements();
                    while (true) {
                        if (!enumeration.hasMoreElements()) break;
                        objectEntry = (ObjectEntry)enumeration.nextElement();
                        if (!objectEntry.deleted && !objectEntry.creating && objectEntry.updatePersistNeeded) {
                            objectEntry.engine.store(this, objectEntry.oid, objectEntry.object);
                        }
                        if (!objectEntry.deleted && !objectEntry.creating && objectEntry.updateCacheNeeded) {
                            objectEntry.engine.softLock(this, objectEntry.oid, this._lockTimeout);
                        }
                        if (!objectEntry.deleted && this._callback != null) {
                            try {
                                this._callback.storing(objectEntry.object, objectEntry.updateCacheNeeded);
                            }
                            catch (Exception exception) {
                                throw new TransactionAbortedException(Messages.format("persist.nested", exception), exception);
                            }
                        }
                        if (objectEntry.deleted || objectEntry.molder.getCallback() == null) continue;
                        try {
                            objectEntry.molder.getCallback().storing(objectEntry.object, objectEntry.updateCacheNeeded);
                        }
                        catch (Exception exception) {
                            throw new TransactionAbortedException(Messages.format("persist.nested", exception), exception);
                        }
                    }
                    this._status = 7;
                    objectEntry = this._deletedList;
                    int n3 = 0;
                    while (true) {
                        if (objectEntry == null) break;
                        n3 = Math.max(n3, objectEntry.molder.getPriority());
                        objectEntry = objectEntry.nextDeleted;
                    }
                    int n4 = n3;
                    block17: while (true) {
                        if (n4 < 0) break;
                        objectEntry = this._deletedList;
                        while (true) {
                            if (objectEntry == null) {
                                --n4;
                                continue block17;
                            }
                            if (objectEntry.molder.getPriority() == n4) {
                                objectEntry.engine.delete(this, objectEntry.oid, objectEntry.object);
                            }
                            objectEntry = objectEntry.nextDeleted;
                        }
                        break;
                    }
                    this._deletedList = null;
                    this._status = 2;
                    boolean bl3 = true;
                    Object var12_5 = null;
                    this.closeConnections();
                    return bl3;
                }
                this._status = 2;
                bl = false;
                Object var12_4 = null;
            }
            catch (Exception exception) {
                this._status = 1;
                if (!(exception instanceof TransactionAbortedException)) throw new TransactionAbortedException(Messages.format("persist.nested", exception), exception);
                throw (TransactionAbortedException)exception;
            }
        }
        catch (Throwable throwable) {
            Object var12_6 = null;
            this.closeConnections();
            throw throwable;
        }
        this.closeConnections();
        return bl;
    }

    public synchronized void commit() throws TransactionAbortedException {
        if (this._status == 1) {
            throw new TransactionAbortedException("persist.markedRollback");
        }
        if (this._status != 2) {
            throw new IllegalStateException(Messages.message("persist.missingPrepare"));
        }
        try {
            this._status = 8;
            this.commitConnections();
        }
        catch (Exception exception) {
            this._status = 1;
            throw new TransactionAbortedException(Messages.format("persist.nested", exception), exception);
        }
        Enumeration enumeration = this._objects.elements();
        while (enumeration.hasMoreElements()) {
            ObjectEntry objectEntry = (ObjectEntry)enumeration.nextElement();
            if (objectEntry.deleted) {
                objectEntry.engine.forgetObject(this, objectEntry.oid);
                objectEntry.molder.setFieldsNull(objectEntry.object);
            } else {
                if (objectEntry.updateCacheNeeded) {
                    objectEntry.engine.updateCache(this, objectEntry.oid, objectEntry.object);
                }
                objectEntry.engine.releaseLock(this, objectEntry.oid);
            }
            if (this._callback != null) {
                this._callback.releasing(objectEntry.object, true);
                continue;
            }
            if (objectEntry.molder.getCallback() == null) continue;
            objectEntry.molder.getCallback().releasing(objectEntry.object, true);
        }
        this._objects.removeAllElements();
        this._engineOids.clear();
        this._readOnlyObjects.clear();
        this._status = 3;
    }

    public synchronized void rollback() {
        ObjectEntry objectEntry;
        if (this._status != 0 && this._status != 2 && this._status != 1) {
            throw new IllegalStateException(Messages.message("persist.noTransaction"));
        }
        this.rollbackConnections();
        Enumeration enumeration = this._objects.elements();
        while (enumeration.hasMoreElements()) {
            objectEntry = (ObjectEntry)enumeration.nextElement();
            if (!objectEntry.deleted) continue;
            objectEntry.deleted = false;
        }
        enumeration = this._objects.elements();
        while (enumeration.hasMoreElements()) {
            objectEntry = (ObjectEntry)enumeration.nextElement();
            try {
                if (!objectEntry.creating) {
                    if (objectEntry.created) {
                        objectEntry.engine.revertObject(this, objectEntry.oid, objectEntry.object);
                        objectEntry.engine.forgetObject(this, objectEntry.oid);
                    } else {
                        objectEntry.engine.revertObject(this, objectEntry.oid, objectEntry.object);
                        objectEntry.engine.releaseLock(this, objectEntry.oid);
                    }
                }
                if (this._callback != null) {
                    this._callback.releasing(objectEntry.object, false);
                    continue;
                }
                if (objectEntry.molder.getCallback() == null) continue;
                objectEntry.molder.getCallback().releasing(objectEntry.object, false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this._objects.removeAllElements();
        this._engineOids.clear();
        this._readOnlyObjects.clear();
        while (this._deletedList != null) {
            objectEntry = this._deletedList;
            this._deletedList = objectEntry.nextDeleted;
            objectEntry.nextDeleted = null;
        }
        this._status = 4;
    }

    public synchronized void close() throws TransactionAbortedException {
        if (this._status != 0 && this._status != 1) {
            throw new IllegalStateException(Messages.message("persist.missingEnd"));
        }
        try {
            this.closeConnections();
        }
        catch (Exception exception) {
            this._status = 1;
            throw new TransactionAbortedException(Messages.format("persist.nested", exception), exception);
        }
    }

    public boolean isPersistent(Object object) {
        ObjectEntry objectEntry = this.getObjectEntry(object);
        return objectEntry != null && !objectEntry.deleted;
    }

    public boolean isRecorded(Object object) {
        ObjectEntry objectEntry = this.getObjectEntry(object);
        return objectEntry != null;
    }

    public boolean isDepended(OID oID, Object object) {
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (objectEntry == null) {
            return false;
        }
        OID oID2 = objectEntry.oid.getDepends();
        if (oID2 == null) {
            return false;
        }
        return oID2.equals(oID);
    }

    public Object getIdentity(Object object) {
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (objectEntry != null) {
            return objectEntry.oid.getIdentity();
        }
        return null;
    }

    public int getStatus() {
        return this._status;
    }

    public boolean isOpen() {
        return this._status == 0 || this._status == 1;
    }

    protected Xid getXid() {
        return this._xid;
    }

    void setWaitOnLock(ObjectLock objectLock) {
        this._waitOnLock = objectLock;
    }

    ObjectLock getWaitOnLock() {
        return this._waitOnLock;
    }

    public boolean isDeleted(Object object) {
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (objectEntry != null) {
            return objectEntry.deleted;
        }
        return false;
    }

    public boolean isDeletedByOID(OID oID) {
        ObjectEntry objectEntry = this.getObjectEntry(oID.getLockEngine(), oID);
        if (objectEntry != null) {
            return objectEntry.deleted;
        }
        return false;
    }

    public int getObjectState(Object object) {
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (objectEntry != null) {
            if (objectEntry.created && !objectEntry.deleted) {
                return OBJECT_STATE_PERSISTENT_NEW;
            }
            if (objectEntry.created && objectEntry.deleted) {
                return OBJECT_STATE_PERSISTENT_NEW_DELETED;
            }
            if (objectEntry.deleted) {
                return OBJECT_STATE_PERSISTENT_DELETED;
            }
            return OBJECT_STATE_PERSISTENT;
        }
        Iterator iterator = this._readOnlyObjects.values().iterator();
        while (iterator.hasNext()) {
            if (object != ((ObjectEntry)iterator.next()).object) continue;
            return OBJECT_STATE_READ_ONLY;
        }
        return OBJECT_STATE_TRANSIENT;
    }

    public ClassLoader getClassLoader() {
        return this._db.getClassLoader();
    }

    void markDelete(LockEngine lockEngine, Class clazz, Object object) throws LockNotGrantedException, PersistenceException {
        ObjectEntry objectEntry = this.getObjectEntry(lockEngine, new OID(lockEngine, lockEngine.getClassMolder(clazz), object));
        if (objectEntry != null && !objectEntry.deleted) {
            try {
                if (objectEntry.molder != null && this._callback != null) {
                    this._callback.removing(objectEntry.object);
                } else if (objectEntry.molder != null && objectEntry.molder.getCallback() != null) {
                    objectEntry.molder.getCallback().removing(objectEntry.object);
                }
            }
            catch (Exception exception) {
                throw new PersistenceException(Messages.format("persist.nested", exception));
            }
            try {
                objectEntry.deleted = true;
                objectEntry.engine.softLock(this, objectEntry.oid, this._lockTimeout);
                objectEntry.engine.markDelete(this, objectEntry.oid, null, this._lockTimeout);
                if (this._deletedList == null) {
                    this._deletedList = objectEntry;
                } else {
                    ObjectEntry objectEntry2 = this._deletedList;
                    while (objectEntry2.nextDeleted != null) {
                        objectEntry2 = objectEntry2.nextDeleted;
                    }
                    objectEntry2.nextDeleted = objectEntry;
                }
                try {
                    if (this._callback != null) {
                        this._callback.removed(objectEntry.object);
                    } else if (objectEntry.molder.getCallback() != null) {
                        objectEntry.molder.getCallback().removed(objectEntry.object);
                    }
                }
                catch (Exception exception) {
                    throw new PersistenceException(Messages.format("persist.nested", exception));
                }
            }
            catch (ObjectDeletedException objectDeletedException) {
                this.removeObjectEntry(objectEntry.object);
            }
        }
    }

    ObjectEntry addObjectEntry(OID oID, Object object) {
        if (oID == null) {
            throw new IllegalArgumentException("oid cannot be null");
        }
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        LockEngine lockEngine = oID.getLockEngine();
        ClassMolder classMolder = oID.getMolder();
        this.removeObjectEntry(object);
        ObjectEntry objectEntry = new ObjectEntry(lockEngine, classMolder, oID, object);
        objectEntry.oid = oID;
        this._objects.addElement(objectEntry);
        Hashtable<OID, ObjectEntry> hashtable = (Hashtable<OID, ObjectEntry>)this._engineOids.get(lockEngine);
        if (hashtable == null) {
            hashtable = new Hashtable<OID, ObjectEntry>();
            this._engineOids.put(lockEngine, hashtable);
        }
        hashtable.put(oID, objectEntry);
        return objectEntry;
    }

    ObjectEntry getObjectEntry(LockEngine lockEngine, OID oID) {
        Hashtable hashtable = (Hashtable)this._engineOids.get(lockEngine);
        if (hashtable == null) {
            return null;
        }
        return (ObjectEntry)hashtable.get(oID);
    }

    ObjectEntry rehash(Object object, OID oID) {
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (objectEntry == null) {
            throw new IllegalArgumentException("ObjectEntry to be rehash is not found");
        }
        Hashtable hashtable = (Hashtable)this._engineOids.get(objectEntry.engine);
        hashtable.remove(objectEntry.oid);
        hashtable.put(oID, objectEntry);
        objectEntry.oid = oID;
        return objectEntry;
    }

    ObjectEntry getObjectEntry(Object object) {
        Enumeration enumeration = this._objects.elements();
        while (enumeration.hasMoreElements()) {
            ObjectEntry objectEntry = (ObjectEntry)enumeration.nextElement();
            if (objectEntry.object != object) continue;
            return objectEntry;
        }
        return null;
    }

    ObjectEntry removeObjectEntry(Object object) {
        int n = this._objects.size();
        int n2 = 0;
        while (n2 < n) {
            ObjectEntry objectEntry = (ObjectEntry)this._objects.elementAt(n2);
            if (objectEntry.object == object) {
                this._objects.removeElementAt(n2);
                ((Hashtable)this._engineOids.get(objectEntry.engine)).remove(objectEntry.oid);
                return objectEntry;
            }
            ++n2;
        }
        return null;
    }

    void makeReadOnly(Object object) {
        ObjectEntry objectEntry = this.removeObjectEntry(object);
        if (objectEntry == null) {
            throw new IllegalStateException(Messages.format("persist.internal", "Attempt to make read-only object that is not in transaction"));
        }
        this._readOnlyObjects.put(objectEntry.oid, objectEntry);
        objectEntry.engine.releaseLock(this, objectEntry.oid);
    }

    ObjectEntry getReadOnlyObjectEntry(OID oID) {
        return (ObjectEntry)this._readOnlyObjects.get(oID);
    }

    public boolean isReadOnly(Object object) {
        return this.getObjectState(object) == OBJECT_STATE_READ_ONLY;
    }

    static short toDatabaseAccessMode(AccessMode accessMode) {
        if (accessMode == AccessMode.Shared) {
            return 1;
        }
        if (accessMode == AccessMode.ReadOnly) {
            return 0;
        }
        if (accessMode == AccessMode.DbLocked) {
            return 3;
        }
        if (accessMode == AccessMode.Exclusive) {
            return 2;
        }
        return -1;
    }

    static final class ObjectEntry {
        final LockEngine engine;
        final ClassMolder molder;
        final Object object;
        OID oid;
        boolean deleted;
        boolean created;
        boolean creating;
        boolean updateCacheNeeded;
        boolean updatePersistNeeded;
        ObjectEntry nextDeleted;

        ObjectEntry(LockEngine lockEngine, ClassMolder classMolder, OID oID, Object object) {
            this.engine = lockEngine;
            this.molder = classMolder;
            this.oid = oID;
            this.object = object;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.oid);
            stringBuffer.append('\t');
            stringBuffer.append("deleted: ");
            stringBuffer.append(this.deleted);
            stringBuffer.append('\t');
            stringBuffer.append("creating: ");
            stringBuffer.append(this.creating);
            stringBuffer.append('\t');
            stringBuffer.append("created: ");
            stringBuffer.append(this.created);
            stringBuffer.append('\t');
            stringBuffer.append("deleted: ");
            stringBuffer.append(this.deleted);
            return stringBuffer.toString();
        }
    }
}

