/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.xml.serialize.Serializer;
import org.exolab.castor.types.OperationNotSupportedException;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.Stack;
import org.exolab.castor.xml.util.AnyNode2SAX;
import org.xml.sax.SAXException;

public final class AnyNode {
    private static final String XMLNS_PREFIX = "xmlns";
    public static final short ELEMENT = 1;
    public static final short ATTRIBUTE = 2;
    public static final short NAMESPACE = 3;
    public static final short PI = 4;
    public static final short COMMENT = 5;
    public static final short TEXT = 6;
    private short _nodeType = 1;
    private AnyNode _nextSiblingNode = null;
    private AnyNode _firstChildNode = null;
    private String _localName;
    private String _uri;
    private String _prefix;
    private static Stack _elements;
    private String _value;

    public AnyNode() {
        this(1, null, null, null, null);
    }

    public AnyNode(short s, String string, String string2, String string3, String string4) {
        if (s > 6 && s < 1) {
            throw new IllegalArgumentException("Illegal node type");
        }
        this._nodeType = s;
        if (s > 4 && string != null) {
            String string5 = "This node can not have a local name";
            throw new IllegalArgumentException(string5);
        }
        this._localName = string;
        if (s > 3 && (string3 != null || string2 != null)) {
            String string6 = "This node can not handle namespace";
            throw new IllegalArgumentException(string6);
        }
        this._uri = string3;
        this._prefix = string2;
        if (s == 2 && string.startsWith(XMLNS_PREFIX)) {
            String string7 = "Namespaces can't be used as attributes.";
            throw new IllegalArgumentException(string7);
        }
        if (s == 1 && string4 != null) {
            String string8 = "You can't set a value for this node type";
            throw new IllegalArgumentException(string8);
        }
        this._value = string4;
    }

    public void addAnyNode(AnyNode anyNode) {
        if (anyNode == null) {
            throw new IllegalArgumentException("null argument in addAnyNode");
        }
        switch (anyNode.getNodeType()) {
            case 2: {
                this.addAttribute(anyNode);
                break;
            }
            case 3: {
                this.addNamespace(anyNode);
                break;
            }
            default: {
                this.addChild(anyNode);
            }
        }
    }

    public void addChild(AnyNode anyNode) {
        if (anyNode == null) {
            throw new IllegalArgumentException("null argument in appendChild");
        }
        if (anyNode.getNodeType() == 2 || anyNode.getNodeType() == 3) {
            throw new IllegalArgumentException("An Attribute or an Namespace can't be added as a child");
        }
        if (this.getNodeType() == 6) {
            throw new IllegalArgumentException("a TEXT node can't have children.");
        }
        if (this._firstChildNode == null) {
            this._firstChildNode = anyNode;
        } else if (this._firstChildNode.getNodeType() == 2 || this._firstChildNode.getNodeType() == 3) {
            this._firstChildNode.addChild(anyNode);
        } else {
            this._firstChildNode.appendSibling(anyNode);
        }
    }

    public void addAttribute(AnyNode anyNode) {
        if (anyNode == null) {
            throw new IllegalArgumentException("null argument in addAttribute");
        }
        if (anyNode.getNodeType() != 2) {
            throw new IllegalArgumentException("Only attribute can be added as an attribute");
        }
        if (this._firstChildNode == null) {
            this._firstChildNode = anyNode;
        } else if (this._firstChildNode.getNodeType() == 2) {
            this._firstChildNode.appendSibling(anyNode);
        } else if (this._firstChildNode.getNodeType() == 3) {
            this._firstChildNode.addAttribute(anyNode);
        } else {
            anyNode.addChild(this._firstChildNode);
            this._firstChildNode = anyNode;
        }
    }

    public void addNamespace(AnyNode anyNode) {
        if (anyNode == null) {
            throw new IllegalArgumentException("null argument in addNamespace");
        }
        if (anyNode.getNodeType() != 3) {
            throw new IllegalArgumentException("Only namespace can be added as an namespace");
        }
        if (this._firstChildNode == null) {
            this._firstChildNode = anyNode;
        } else if (this._firstChildNode.getNodeType() == 3) {
            this._firstChildNode.appendSibling(anyNode);
        } else if (this._firstChildNode.getNodeType() == 2) {
            this._firstChildNode.addNamespace(anyNode);
        } else {
            anyNode.addChild(this._firstChildNode);
            this._firstChildNode = anyNode;
        }
    }

    public AnyNode getFirstAttribute() {
        if (this.getNodeType() != 1) {
            String string = "This node type can not contain attributes";
            throw new OperationNotSupportedException(string);
        }
        boolean bl = false;
        AnyNode anyNode = this.getFirstChildNode();
        while (anyNode != null && !bl) {
            short s = anyNode.getNodeType();
            if (s == 1 || s == 5 || s == 6 || s == 4) {
                anyNode = null;
                continue;
            }
            if (s == 3) {
                anyNode = anyNode.getFirstChildNode();
                continue;
            }
            bl = true;
        }
        return anyNode;
    }

    public AnyNode getFirstNamespace() {
        if (this.getNodeType() != 1) {
            String string = "This node type can not contain namespaces";
            throw new OperationNotSupportedException(string);
        }
        AnyNode anyNode = this.getFirstChildNode();
        boolean bl = false;
        while (anyNode != null && !bl) {
            short s = anyNode.getNodeType();
            if (s == 1 || s == 5 || s == 6 || s == 4) {
                anyNode = null;
                continue;
            }
            if (s == 2) {
                anyNode = anyNode.getFirstChildNode();
                continue;
            }
            bl = true;
        }
        return anyNode;
    }

    public AnyNode getFirstChild() {
        if (this.getNodeType() == 2 || this.getNodeType() == 3) {
            return null;
        }
        AnyNode anyNode = this.getFirstChildNode();
        boolean bl = false;
        while (anyNode != null && !bl) {
            short s = anyNode.getNodeType();
            if (s == 1 || s == 5 || s == 6 || s == 4) {
                bl = true;
                continue;
            }
            if (s != 2 && s != 3) continue;
            anyNode = anyNode.getFirstChildNode();
        }
        return anyNode;
    }

    public AnyNode getNextSibling() {
        return this._nextSiblingNode;
    }

    public short getNodeType() {
        return this._nodeType;
    }

    public String getLocalName() {
        return this._localName;
    }

    public String getNamespaceURI() {
        return this._uri;
    }

    public String getStringValue() {
        switch (this._nodeType) {
            case 2: 
            case 6: {
                return this._value;
            }
            case 3: {
                return this._uri;
            }
            case 4: {
                return "";
            }
            case 5: {
                return this._value;
            }
            case 1: {
                StringBuffer stringBuffer = new StringBuffer(4096);
                AnyNode anyNode = this.getNextSibling();
                while (anyNode != null && anyNode.getNodeType() == 6) {
                    stringBuffer.append(anyNode.getStringValue());
                    anyNode = anyNode.getNextSibling();
                }
                anyNode = this.getFirstChild();
                while (anyNode != null) {
                    stringBuffer.append(anyNode.getStringValue());
                    anyNode = anyNode.getNextSibling();
                }
                anyNode = null;
                return stringBuffer.toString();
            }
        }
        return null;
    }

    public String getNamespacePrefix() {
        return this._prefix;
    }

    public String toString() {
        Serializer serializer = Configuration.getSerializer();
        if (serializer == null) {
            throw new RuntimeException("Unable to obtain serializer");
        }
        StringWriter stringWriter = new StringWriter();
        serializer.setOutputCharStream((Writer)stringWriter);
        try {
            AnyNode2SAX.fireEvents(this, serializer.asDocumentHandler());
        }
        catch (IOException iOException) {
            return this.privateToString();
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException.getMessage());
        }
        return stringWriter.toString();
    }

    private String privateToString() {
        StringBuffer stringBuffer = new StringBuffer(4096);
        if (_elements == null) {
            _elements = new Stack();
        }
        if (_elements.search(this) == -1) {
            _elements.push(this);
            if (this.getNodeType() == 1) {
                AnyNode anyNode = this.getNextSibling();
                stringBuffer.append("<");
                String string = this.getNamespacePrefix();
                if (string != null) {
                    stringBuffer.append(string + ":");
                }
                string = null;
                stringBuffer.append(this.getLocalName());
                AnyNode anyNode2 = this.getFirstAttribute();
                while (anyNode2 != null) {
                    stringBuffer.append(" ");
                    stringBuffer.append(anyNode2.getLocalName());
                    stringBuffer.append("='" + anyNode2.getStringValue() + "'");
                    anyNode2 = anyNode2.getNextSibling();
                }
                anyNode2 = this.getFirstNamespace();
                while (anyNode2 != null) {
                    stringBuffer.append(" ");
                    stringBuffer.append(XMLNS_PREFIX);
                    string = anyNode2.getNamespacePrefix();
                    if (string != null && string.length() != 0) {
                        stringBuffer.append(":" + string);
                    }
                    stringBuffer.append("='" + anyNode2.getNamespaceURI() + "'");
                    anyNode2 = anyNode2.getNextSibling();
                }
                anyNode2 = this.getFirstChild();
                if (anyNode2 != null) {
                    stringBuffer.append(">");
                    while (anyNode2 != null) {
                        stringBuffer.append(anyNode2.privateToString());
                        anyNode2 = anyNode2.getNextSibling();
                    }
                    stringBuffer.append("</" + this.getLocalName() + ">");
                } else {
                    stringBuffer.append("/>");
                }
            } else {
                stringBuffer.append(this.getStringValue());
            }
            return stringBuffer.toString();
        }
        return stringBuffer.toString();
    }

    protected void appendSibling(AnyNode anyNode) {
        if (anyNode == null) {
            throw new IllegalArgumentException();
        }
        if ((anyNode.getNodeType() == 2 || anyNode.getNodeType() == 3) && this.getNodeType() != anyNode.getNodeType()) {
            String string = "a NAMESPACE or an ATTRIBUTE can only be add as a sibling to a node of the same type";
            throw new OperationNotSupportedException(string);
        }
        if (this._nextSiblingNode == null) {
            if (anyNode.getNodeType() == 6 && this.getNodeType() == 6) {
                this.mergeTextNode(this, anyNode);
            } else {
                this._nextSiblingNode = anyNode;
            }
        } else {
            this._nextSiblingNode.appendSibling(anyNode);
        }
    }

    protected AnyNode getFirstChildNode() {
        return this._firstChildNode;
    }

    private void mergeTextNode(AnyNode anyNode, AnyNode anyNode2) {
        if (anyNode.getNodeType() != anyNode2.getNodeType()) {
            return;
        }
        if (anyNode.getNodeType() != 6) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(anyNode.getStringValue());
        stringBuffer.append(anyNode2.getStringValue());
        anyNode._value = stringBuffer.toString();
        anyNode2 = null;
    }
}

