/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;

public class ModelGroup
extends Group {
    private String _groupRef = null;
    private Vector _modelDefs;
    private Schema _schema = null;

    public ModelGroup() {
        this((Schema)null);
    }

    public ModelGroup(Schema schema) {
        this(null, schema);
    }

    public ModelGroup(String string, Schema schema) {
        super(string);
        this._schema = schema;
        this._modelDefs = new Vector();
    }

    public void addModelGroup(ModelGroup modelGroup) {
        if (!this._modelDefs.contains(modelGroup)) {
            this._modelDefs.addElement(modelGroup);
        }
    }

    public Enumeration enumerate() {
        return this.getContentModelGroup().enumerate();
    }

    public Enumeration getDeclarations() {
        return this._modelDefs.elements();
    }

    public ContentModelGroup getContentModelGroup() {
        if (this._groupRef != null) {
            return this.getReference().getContentModelGroup();
        }
        return super.getContentModelGroup();
    }

    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean bl) {
        if (!bl && this._groupRef != null) {
            String string = this._groupRef;
            int n = string.indexOf(58);
            if (n > 0) {
                string = string.substring(n + 1);
            }
            return string;
        }
        return super.getName();
    }

    public void setReference(String string) {
        this._groupRef = string;
    }

    public short getStructureType() {
        return 16;
    }

    public String getReferenceId() {
        if (this.getName() != null) {
            return "group:" + this.getName();
        }
        return null;
    }

    public ModelGroup getReference() {
        ModelGroup modelGroup = null;
        if (this._groupRef != null && (modelGroup = this._schema.getModelGroup(this._groupRef)) == null) {
            String string = "Unable to find group referenced :\" ";
            string = string + this.getName();
            string = string + "\"";
            throw new IllegalStateException(string);
        }
        return modelGroup;
    }

    public boolean hasReference() {
        if (this._groupRef != null) {
            return this._groupRef.length() != 0;
        }
        return false;
    }

    public void validate() throws ValidationException {
        if (this.getParent() != null && this.getParent().getStructureType() != 19 && this.getName(true) != null) {
            String string = "Only top-level model group definition (<group>) can be named.";
            string = string + this.getName() + "is not a valid model group definition.";
            throw new ValidationException(string);
        }
        if (this.getContentModelGroup() == null) {
            String string = "<group> should contains :\" ";
            string = string + " 'all' or 'sequence' or 'choice'";
            string = string + "\"";
            throw new ValidationException(string);
        }
        int n = 0;
        while (n < this.getParticleCount()) {
            Particle particle = this.getParticle(n);
            switch (particle.getStructureType()) {
                case 16: {
                    ModelGroup modelGroup = (ModelGroup)particle;
                    String string = null;
                    if (modelGroup.getReference() != null) {
                        string = modelGroup.getReference().getName();
                    }
                    if (string != null && string.equals(this.getName())) {
                        String string2 = "in <group> named:" + this.getName();
                        string2 = string2 + "\nCircular groups are disallowed.\n";
                        string2 = string2 + "That is, within the {particles} of a group there must not be at any depth a particle whose {term} is the group itself.\n";
                        throw new ValidationException(string2);
                    }
                    int n2 = 0;
                    modelGroup = modelGroup.getReference();
                    while (n2 < modelGroup.getParticleCount()) {
                        ModelGroup modelGroup2;
                        if (modelGroup.getParticle(n2).getStructureType() == 16 && (modelGroup2 = ((ModelGroup)modelGroup.getParticle(n2)).getReference()) != null && modelGroup2.equals(this)) {
                            String string3 = "Cross reference between <group>:" + this.getName() + " and <group>:" + modelGroup.getName();
                            string3 = string3 + "\nCircular groups are disallowed.\n";
                            string3 = string3 + "That is, within the {particles} of a group there must not be at any depth a particle whose {term} is the group itself.\n";
                            throw new ValidationException(string3);
                        }
                        ++n2;
                    }
                    break;
                }
            }
            ++n;
        }
    }

    public Schema getSchema() {
        return this._schema;
    }

    public void setSchema(Schema schema) {
        this._schema = schema;
    }
}

