/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.validators.PatternValidator;

public class ShortValidator
extends PatternValidator
implements TypeValidator {
    private boolean useMin = false;
    private boolean useMax = false;
    private boolean useFixed = false;
    private short min = 0;
    private short max = 0;
    private short fixed = 0;

    public void clearFixed() {
        this.useFixed = false;
    }

    public void clearMax() {
        this.useMax = false;
    }

    public void clearMin() {
        this.useMin = false;
    }

    public void setFixed(short s) {
        this.useFixed = true;
        this.fixed = s;
    }

    public void setMinExclusive(short s) {
        this.useMin = true;
        this.min = (short)(s + 1);
    }

    public void setMinInclusive(short s) {
        this.useMin = true;
        this.min = s;
    }

    public void setMaxExclusive(short s) {
        this.useMax = true;
        this.max = (short)(s - 1);
    }

    public void setMaxInclusive(short s) {
        this.useMax = true;
        this.max = s;
    }

    public void validate(short s) throws ValidationException {
        if (this.useFixed) {
            if (s != this.fixed) {
                String string = s + " is not equal to the fixed value of " + this.fixed;
                throw new ValidationException(string);
            }
            return;
        }
        if (this.useMin && s < this.min) {
            String string = s + " is less than the minimum allowable ";
            string = string + "value of " + this.min;
            throw new ValidationException(string);
        }
        if (this.useMax && s > this.max) {
            String string = s + " is greater than the maximum allowable ";
            string = string + "value of " + this.max;
            throw new ValidationException(string);
        }
        if (this.hasPattern()) {
            super.validate(Short.toString(s));
        }
    }

    public void validate(Object object) throws ValidationException {
        if (object == null) {
            String string = "ShortValidator cannot validate a null object.";
            throw new ValidationException(string);
        }
        short s = 0;
        try {
            s = (Short)object;
        }
        catch (Exception exception) {
            String string = "Expecting a Short, received instead: ";
            string = string + object.getClass().getName();
            throw new ValidationException(string);
        }
        this.validate(s);
    }
}

