/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.Utils;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.AttributeInfoList;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.Code;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.Exceptions;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.LineNumberTable;

public class MethodInfo {
    protected ConstantPool constantPool;
    protected int access_flags;
    protected int name_index;
    protected int descriptor_index;
    protected Code code;
    protected boolean deprecated;
    protected boolean synthetic;
    protected Exceptions exceptions;

    public MethodInfo(ConstantPool pool) {
        this.constantPool = pool;
    }

    public void read(DataInputStream dis) throws IOException {
        this.access_flags = dis.readShort();
        this.name_index = dis.readShort();
        this.descriptor_index = dis.readShort();
        AttributeInfoList attrlist = new AttributeInfoList(this.constantPool);
        attrlist.read(dis);
        this.code = (Code)attrlist.getAttribute("Code");
        this.synthetic = attrlist.getAttribute("Synthetic") != null;
        this.deprecated = attrlist.getAttribute("Deprecated") != null;
        this.exceptions = (Exceptions)attrlist.getAttribute("Exceptions");
    }

    public int getAccessFlags() {
        return this.access_flags;
    }

    public String getName() {
        return Utils.getUTF8Value(this.constantPool, this.name_index);
    }

    public String getDescriptor() {
        return Utils.getUTF8Value(this.constantPool, this.descriptor_index);
    }

    public String getFullSignature() {
        return this.getReturnType() + " " + this.getShortSignature();
    }

    public String getShortSignature() {
        StringBuffer buf = new StringBuffer(this.getName());
        buf.append("(");
        String[] params = this.getParametersType();
        int i = 0;
        while (i < params.length) {
            buf.append(params[i]);
            if (i != params.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    public String getReturnType() {
        return Utils.getMethodReturnType(this.getDescriptor());
    }

    public String[] getParametersType() {
        return Utils.getMethodParams(this.getDescriptor());
    }

    public Code getCode() {
        return this.code;
    }

    public int getNumberOfLines() {
        LineNumberTable lnt;
        int len = -1;
        if (this.code != null && (lnt = this.code.getLineNumberTable()) != null) {
            len = lnt.length();
        }
        return len;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public String getAccess() {
        return Utils.getMethodAccess(this.access_flags);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Method: ").append(this.getAccess()).append(" ");
        sb.append(this.getFullSignature());
        sb.append(" synthetic:").append(this.synthetic);
        sb.append(" deprecated:").append(this.deprecated);
        return sb.toString();
    }
}

